/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.utils.Objects;
import io.fabric8.utils.Zips;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(MavenUtil.class);
    private static final String DEFAULT_CONFIG_FILE_NAME = "kubernetes.json";

    public static boolean isKubernetesJsonArtifact(String classifier, String type) {
        return "json".equals(type) && "kubernetes".equals(classifier);
    }

    public static boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals(DEFAULT_CONFIG_FILE_NAME)) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }

    public static File extractKubernetesJson(File f, Path dir) throws IOException {
        if (MavenUtil.hasKubernetesJson(f)) {
            Zips.unzip((InputStream)new FileInputStream(f), (File)dir.toFile());
            File result = dir.resolve(DEFAULT_CONFIG_FILE_NAME).toFile();
            return result.exists() ? result : null;
        }
        return null;
    }

    public static URLClassLoader getCompileClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getCompileClasspathElements();
            return MavenUtil.createClassLoader(classpathElements, project.getBuild().getOutputDirectory());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalArgumentException("Cannot resolve artifact from compile classpath", e);
        }
    }

    public static URLClassLoader getTestClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getTestClasspathElements();
            return MavenUtil.createClassLoader(classpathElements, project.getBuild().getTestOutputDirectory());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalArgumentException("Cannot resolve artifact from test classpath", e);
        }
    }

    public static String createDefaultResourceName(MavenProject project, String ... suffixes) {
        String suffix = StringUtils.join((Object[])suffixes, (String)"-");
        String ret = project.getArtifactId() + (suffix.length() > 0 ? "-" + suffix : "");
        if (ret.length() > 24) {
            ret = ret.substring(0, 24);
        }
        return ret.toLowerCase();
    }

    private static URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = MavenUtil.pathToUrl(path);
            urls.add(url);
        }
        for (Object e : classpathElements) {
            if (e == null) continue;
            String path = e.toString();
            URL url = MavenUtil.pathToUrl(path);
            urls.add(url);
        }
        return MavenUtil.createURLClassLoader(urls);
    }

    private static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    private static URL pathToUrl(String path) {
        try {
            File file = new File(path);
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to a an URL: %s", path, e.getMessage()), e);
        }
    }

    public static boolean hasDependency(MavenProject project, String groupId) {
        Set artifacts = project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                String scope = artifact.getScope();
                if (Objects.equal((Object)"test", (Object)scope) || !Objects.equal((Object)groupId, (Object)artifact.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPlugin(MavenProject project, String plugin) {
        return project.getPlugin(plugin) != null;
    }

    public static boolean hasClass(MavenProject project, String ... classNames) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        for (String className : classNames) {
            try {
                compileClassLoader.loadClass(className);
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    public static Properties getSpringBootApplicationProperties(MavenProject project) {
        return MavenUtil.getPropertiesFile(project, "application.properties");
    }

    public static Properties getPropertiesFile(MavenProject project, String propertiesFileName) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        URL resource = compileClassLoader.findResource(propertiesFileName);
        Properties answer = new Properties();
        if (resource != null) {
            try {
                answer.load(resource.openStream());
            }
            catch (IOException e) {
                LOG.error("Failed to load properties from: " + resource + ". " + e, (Throwable)e);
            }
        }
        return answer;
    }

    public static MavenProject getRootProject(MavenProject project) {
        MavenProject parent;
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }

    public static void createArchive(File sourceDir, File destinationFile, TarArchiver archiver) throws MojoExecutionException {
        try {
            archiver.setCompression(TarArchiver.TarCompressionMethod.gzip);
            archiver.setLongfile(TarLongFileMode.posix);
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create archive " + destinationFile + ": " + e, (Exception)e);
        }
    }

    public static void createArchive(File sourceDir, File destinationFile, ZipArchiver archiver) throws MojoExecutionException {
        try {
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create archive " + destinationFile + ": " + e, (Exception)e);
        }
    }

    public static void createArchive(File sourceDir, File destinationFile, JarArchiver archiver) throws MojoExecutionException {
        try {
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create archive " + destinationFile + ": " + e, (Exception)e);
        }
    }
}

