/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.PluginServiceFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class ClassUtil {
    public static Set<String> getResources(String resource) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        for (ClassLoader cl : ClassUtil.getClassLoaders()) {
            Enumeration<URL> urlEnum = cl.getResources(resource);
            ret.addAll(ClassUtil.extractUrlAsStringsFromEnumeration(urlEnum));
        }
        return ret;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), PluginServiceFactory.class.getClassLoader()};
    }

    private static Set<String> extractUrlAsStringsFromEnumeration(Enumeration<URL> urlEnum) {
        HashSet<String> ret = new HashSet<String>();
        while (urlEnum.hasMoreElements()) {
            ret.add(urlEnum.nextElement().toExternalForm());
        }
        return ret;
    }

    public static <T> Class<T> classForName(String className) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        ClassLoader[] classLoaderArray = ClassUtil.getClassLoaders();
        int n = classLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            for (ClassLoader loader = classLoaderArray[i]; loader != null; loader = loader.getParent()) {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(className, true, loader);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                tried.add(loader);
            }
        }
        return null;
    }
}

