/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.docker.util.Logger;
import io.fabric8.utils.Closeables;
import io.fabric8.utils.Function;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ProcessUtil {
    public static int runCommand(Logger log, String commands, String message) throws IOException {
        Function<String, Void> outputHandler = ProcessUtil.createOutputHandler(log);
        return ProcessUtil.runCommand(log, commands, outputHandler, ProcessUtil.createErrorHandler(log), message);
    }

    public static int runCommandAsync(Logger log, String commands, String message) throws IOException {
        return ProcessUtil.runCommand(log, commands, ProcessUtil.createOutputHandler(log), ProcessUtil.createErrorHandler(log), message);
    }

    public static int runCommand(Logger log, String commands, Function<String, Void> outputHandler, Function<String, Void> errorHandler, String message) throws IOException {
        Process process;
        log.debug("Executing commands: " + commands, new Object[0]);
        try {
            process = Runtime.getRuntime().exec(commands);
            ProcessUtil.processOutput(log, process.getInputStream(), outputHandler, message);
            ProcessUtil.processOutput(log, process.getErrorStream(), errorHandler, message);
        }
        catch (Exception e) {
            throw new IOException("Failed to execute process stdin for " + message + ": " + e, e);
        }
        return process.exitValue();
    }

    public static int processCommandAsync(Process process, Logger log, String threadName, String message) throws InterruptedException {
        return ProcessUtil.processCommandAsync(process, log, threadName, ProcessUtil.createOutputHandler(log), ProcessUtil.createErrorHandler(log), message);
    }

    public static int processCommandAsync(final Process process, final Logger log, final String threadName, final Function<String, Void> outputHandler, final Function<String, Void> errorHandler, final String message) throws InterruptedException {
        ProcessUtil.startThread(new Thread(threadName + " read output"){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(log, process.getInputStream(), (Function<String, Void>)outputHandler, message);
                }
                catch (IOException e) {
                    log.error("Failed to read " + threadName + " output ." + e, new Object[]{e});
                }
            }
        });
        ProcessUtil.startThread(new Thread(threadName + " read error"){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(log, process.getErrorStream(), (Function<String, Void>)errorHandler, message);
                }
                catch (IOException e) {
                    log.error("Failed to read " + threadName + " error ." + e, new Object[]{e});
                }
            }
        });
        return process.waitFor();
    }

    private static void startThread(Thread thread) {
        thread.start();
    }

    protected static void processErrors(Logger log, InputStream inputStream, String message) throws Exception {
        ProcessUtil.readProcessOutput(log, inputStream, "stderr for ", message);
    }

    protected static void readProcessOutput(final Logger log, InputStream inputStream, final String prefix, final String message) throws Exception {
        Function<String, Void> function = new Function<String, Void>(){

            public Void apply(String line) {
                log.debug("Error " + prefix + message + ": " + line, new Object[0]);
                return null;
            }
        };
        ProcessUtil.processOutput(log, inputStream, function, prefix + message);
    }

    protected static void processOutput(Logger log, InputStream inputStream, Function<String, Void> function, String errrorMessage) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                function.apply((Object)line);
            }
        }
        catch (Exception e) {
            log.error("Failed to process " + errrorMessage + ": " + e, new Object[]{e});
            throw e;
        }
        finally {
            Closeables.closeQuietly((Reader)reader);
        }
    }

    public static File findExecutable(Logger log, String name) {
        List<File> pathDirectories = ProcessUtil.getPathDirectories(log);
        for (File directory : pathDirectories) {
            File file = new File(directory, name);
            if (!file.exists() || !file.isFile()) continue;
            if (!file.canExecute()) {
                log.warn("Found " + file + " on the PATH but it is not executable!", new Object[0]);
                continue;
            }
            return file;
        }
        return null;
    }

    public static boolean folderIsOnPath(Logger logger, File dir) {
        List<File> paths = ProcessUtil.getPathDirectories(logger);
        for (File path : paths) {
            if (!ProcessUtil.canonicalPath(path).equals(ProcessUtil.canonicalPath(dir))) continue;
            return true;
        }
        return false;
    }

    private static String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            String absolutePath = file.getAbsolutePath();
            return absolutePath;
        }
    }

    private static List<File> getPathDirectories(Logger log) {
        ArrayList<File> pathDirectories = new ArrayList<File>();
        String pathText = System.getenv("PATH");
        if (Strings.isNullOrBlank((String)pathText)) {
            log.warn("The $PATH environment variable is empty! Usually you have a PATH defined to find binaries. ", new Object[0]);
            log.warn("Please report this to the fabric8 team: https://github.com/fabric8io/fabric8-maven-plugin/issues/new", new Object[0]);
        } else {
            String[] pathTexts;
            for (String text : pathTexts = pathText.split(File.pathSeparator)) {
                File dir = new File(text);
                if (!dir.exists() || !dir.isDirectory()) continue;
                pathDirectories.add(dir);
            }
        }
        return pathDirectories;
    }

    protected static Function<String, Void> createOutputHandler(final Logger log) {
        return new Function<String, Void>(){

            public Void apply(String outputLine) {
                log.info(outputLine, new Object[0]);
                return null;
            }
        };
    }

    protected static Function<String, Void> createErrorHandler(final Logger log) {
        return new Function<String, Void>(){

            public Void apply(String outputLine) {
                log.error(outputLine, new Object[0]);
                return null;
            }
        };
    }
}

