/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.extensions.Templates;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Job;
import io.fabric8.kubernetes.api.model.JobSpec;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetSpec;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.internal.HasMetadataComparator;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.core.util.ResourceVersioning;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildStatus;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesResourceUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesResourceUtil.class);
    public static final String API_VERSION = "v1";
    public static final String API_EXTENSIONS_VERSION = "extensions/v1beta1";
    public static final String API_APPS_VERSION = "apps/v1beta1";
    public static final ResourceVersioning DEFAULT_RESOURCE_VERSIONING = new ResourceVersioning().withCoreVersion("v1").withExtensionsVersion("extensions/v1beta1").withAppsVersion("apps/v1beta1");
    public static final HashSet<Class<?>> SIMPLE_FIELD_TYPES = new HashSet();
    protected static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    private static final Map<String, String> FILENAME_TO_KIND_MAPPER = new HashMap<String, String>();
    private static final Map<String, String> KIND_TO_FILENAME_MAPPER = new HashMap<String, String>();
    private static String[] mappings = new String[]{"cm", "ConfigMap", "configmap", "ConfigMap", "cronjob", "CronJob", "cr", "ClusterRole", "crole", "ClusterRole", "clusterrole", "ClusterRole", "crd", "CustomResourceDefinition", "crb", "ClusterRoleBinding", "clusterrb", "ClusterRoleBinding", "cj", "CronJob", "deployment", "Deployment", "is", "ImageStream", "istag", "ImageStreamTag", "lr", "LimitRange", "limitrange", "LimitRange", "ns", "Namespace", "namespace", "Namespace", "oauthclient", "OAuthClient", "pb", "PolicyBinding", "pv", "PersistentVolume", "pvc", "PersistentVolumeClaim", "project", "Project", "pr", "ProjectRequest", "rq", "ResourceQuota", "resourcequota", "ResourceQuota", "role", "Role", "rb", "RoleBinding", "rolebinding", "RoleBinding", "rbr", "RoleBindingRestriction", "rolebindingrestriction", "RoleBindingRestriction", "secret", "Secret", "service", "Service", "svc", "Service", "sa", "ServiceAccount", "rc", "ReplicationController", "rs", "ReplicaSet", "daemonset", "DaemonSet", "ds", "DaemonSet", "statefulset", "StatefulSet", "bc", "BuildConfig", "dc", "DeploymentConfig", "deploymentconfig", "DeploymentConfig", "route", "Route", "template", "Template"};
    private static final String FILENAME_PATTERN = "^(?<name>.*?)(-(?<type>[^-]+))?\\.(?<ext>yaml|yml|json)$";
    private static final String PROFILES_PATTERN = "^profiles?\\.ya?ml$";

    public static KubernetesListBuilder readResourceFragmentsFrom(ResourceVersioning apiVersions, String defaultName, File[] resourceFiles) throws IOException {
        KubernetesListBuilder builder = new KubernetesListBuilder();
        if (resourceFiles != null) {
            for (File file : resourceFiles) {
                HasMetadata resource = KubernetesResourceUtil.getResource(apiVersions, file, defaultName);
                builder.addToItems(new HasMetadata[]{resource});
            }
        }
        return builder;
    }

    public static HasMetadata getResource(ResourceVersioning apiVersions, File file, String appName) throws IOException {
        Map<String, Object> fragment = KubernetesResourceUtil.readAndEnrichFragment(apiVersions, file, appName);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (HasMetadata)mapper.convertValue(fragment, HasMetadata.class);
        }
        catch (ClassCastException exp) {
            throw new IllegalArgumentException(String.format("Resource fragment %s has an invalid syntax (%s)", file.getPath(), exp.getMessage()));
        }
    }

    public static String toYaml(Object resource) throws JsonProcessingException {
        return KubernetesResourceUtil.serializeAsString(resource, ResourceFileType.yaml);
    }

    public static String toJson(Object resource) throws JsonProcessingException {
        return KubernetesResourceUtil.serializeAsString(resource, ResourceFileType.json);
    }

    public static File writeResource(Object resource, File target, ResourceFileType resourceFileType) throws IOException {
        File outputFile = resourceFileType.addExtension(target);
        return KubernetesResourceUtil.writeResourceFile(resource, outputFile, resourceFileType);
    }

    public static File writeResourceFile(Object resource, File outputFile, ResourceFileType resourceFileType) throws IOException {
        String serialized = KubernetesResourceUtil.serializeAsString(resource, resourceFileType);
        Files.writeToFile((File)outputFile, (String)serialized, (Charset)Charset.defaultCharset());
        return outputFile;
    }

    private static String serializeAsString(Object resource, ResourceFileType resourceFileType) throws JsonProcessingException {
        ObjectMapper mapper = resourceFileType.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        return mapper.writeValueAsString(resource);
    }

    public static File[] listResourceFragments(File resourceDir) {
        final Pattern filenamePattern = Pattern.compile(FILENAME_PATTERN);
        final Pattern exludePattern = Pattern.compile(PROFILES_PATTERN);
        return resourceDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return filenamePattern.matcher(name).matches() && !exludePattern.matcher(name).matches();
            }
        });
    }

    private static Map<String, Object> readAndEnrichFragment(ResourceVersioning apiVersions, File file, String appName) throws IOException {
        String kind;
        Pattern pattern = Pattern.compile(FILENAME_PATTERN, 2);
        Matcher matcher = pattern.matcher(file.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Resource file name '%s' does not match pattern <name>-<type>.(yaml|yml|json)", file.getName()));
        }
        String name = matcher.group("name");
        String type = matcher.group("type");
        String ext = matcher.group("ext").toLowerCase();
        Map<String, Object> fragment = KubernetesResourceUtil.readFragment(file, ext);
        if (type != null) {
            kind = KubernetesResourceUtil.getAndValidateKindFromType(file, type);
        } else {
            kind = FILENAME_TO_KIND_MAPPER.get(name.toLowerCase());
            if (kind != null) {
                name = null;
            }
        }
        KubernetesResourceUtil.addKind(fragment, kind, file.getName());
        String apiVersion = apiVersions.getCoreVersion();
        if (Objects.equals(kind, "Deployment") || Objects.equals(kind, "Ingress")) {
            apiVersion = apiVersions.getExtensionsVersion();
        } else if (Objects.equals(kind, "StatefulSet")) {
            apiVersion = apiVersions.getAppsVersion();
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "apiVersion", apiVersion);
        Map<String, Object> metaMap = KubernetesResourceUtil.getMetadata(fragment);
        KubernetesResourceUtil.addIfNotExistent(metaMap, "name", StringUtils.isNotBlank((String)name) ? name : appName);
        return fragment;
    }

    private static String getAndValidateKindFromType(File file, String type) {
        String kind = FILENAME_TO_KIND_MAPPER.get(type.toLowerCase());
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Unknown type '%s' for file %s. Must be one of : %s", type, file.getName(), StringUtils.join(FILENAME_TO_KIND_MAPPER.keySet().iterator(), (String)", ")));
        }
        return kind;
    }

    private static void addKind(Map<String, Object> fragment, String kind, String fileName) {
        if (kind == null && !fragment.containsKey("kind")) {
            throw new IllegalArgumentException("No type given as part of the file name (e.g. 'app-rc.yml') and no 'Kind' defined in resource descriptor " + fileName);
        }
        KubernetesResourceUtil.addIfNotExistent(fragment, "kind", kind);
    }

    private static Map<String, Object> getMetadata(Map<String, Object> fragment) {
        Object mo = fragment.get("metadata");
        if (mo == null) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            fragment.put("metadata", meta);
            return meta;
        }
        if (mo instanceof Map) {
            return (Map)mo;
        }
        throw new IllegalArgumentException("Metadata is expected to be a Map, not a " + mo.getClass());
    }

    private static void addIfNotExistent(Map<String, Object> fragment, String key, String value) {
        if (!fragment.containsKey(key)) {
            fragment.put(key, value);
        }
    }

    private static Map<String, Object> readFragment(File file, String ext) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)("json".equals(ext) ? new JsonFactory() : new YAMLFactory()));
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            Map ret = (Map)mapper.readValue(file, (TypeReference)typeRef);
            return ret != null ? ret : new HashMap();
        }
        catch (JsonProcessingException e) {
            throw new JsonMappingException(String.format("[%s] %s", file, e.getMessage()), e.getLocation(), (Throwable)e);
        }
    }

    public static String getNameWithSuffix(String name, String kind) {
        String suffix = KIND_TO_FILENAME_MAPPER.get(kind);
        return suffix != null ? name + "-" + suffix : name;
    }

    public static String extractContainerName(MavenProject project, ImageConfiguration imageConfig) {
        String alias = imageConfig.getAlias();
        return alias != null ? alias : KubernetesResourceUtil.extractImageUser(imageConfig.getName(), project) + "-" + project.getArtifactId();
    }

    private static String extractImageUser(String image, MavenProject project) {
        ImageName name = new ImageName(image);
        String imageUser = name.getUser();
        return imageUser != null ? imageUser : project.getGroupId();
    }

    public static Map<String, String> removeVersionSelector(Map<String, String> selector) {
        HashMap<String, String> answer = new HashMap<String, String>(selector);
        answer.remove("version");
        return answer;
    }

    public static boolean checkForKind(KubernetesListBuilder builder, String ... kinds) {
        HashSet<String> kindSet = new HashSet<String>(Arrays.asList(kinds));
        for (HasMetadata item : builder.getItems()) {
            if (!kindSet.contains(item.getKind())) continue;
            return true;
        }
        return false;
    }

    public static boolean addPort(List<ContainerPort> ports, String portNumberText, String portName, io.fabric8.maven.docker.util.Logger log) {
        int portValue;
        if (Strings.isNullOrBlank((String)portNumberText)) {
            return false;
        }
        try {
            portValue = Integer.parseInt(portNumberText);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse remote debugging port %s as an integer: %s", new Object[]{portNumberText, e});
            return false;
        }
        for (ContainerPort port : ports) {
            String name = port.getName();
            Integer containerPort = port.getContainerPort();
            if (containerPort == null || containerPort != portValue) continue;
            return false;
        }
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(portName)).withContainerPort(Integer.valueOf(portValue))).build());
        return true;
    }

    public static EnvVar setEnvVarNoOverride(List<EnvVar> envVarList, String name, String value) {
        for (EnvVar envVar : envVarList) {
            String envVarName = envVar.getName();
            if (!io.fabric8.utils.Objects.equal((Object)name, (Object)envVarName)) continue;
            String oldValue = envVar.getValue();
            if (io.fabric8.utils.Objects.equal((Object)value, (Object)oldValue)) {
                return null;
            }
            return envVar;
        }
        EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
        envVarList.add(env);
        return null;
    }

    public static boolean setEnvVar(List<EnvVar> envVarList, String name, String value) {
        for (EnvVar envVar : envVarList) {
            String envVarName = envVar.getName();
            if (!io.fabric8.utils.Objects.equal((Object)name, (Object)envVarName)) continue;
            String oldValue = envVar.getValue();
            if (io.fabric8.utils.Objects.equal((Object)value, (Object)oldValue)) {
                return false;
            }
            envVar.setValue(value);
            return true;
        }
        EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
        envVarList.add(env);
        return true;
    }

    public static String getEnvVar(List<EnvVar> envVarList, String name, String defaultValue) {
        String answer = defaultValue;
        if (envVarList != null) {
            for (EnvVar envVar : envVarList) {
                String value;
                String envVarName = envVar.getName();
                if (!io.fabric8.utils.Objects.equal((Object)name, (Object)envVarName) || !Strings.isNotBlank((String)(value = envVar.getValue()))) continue;
                return value;
            }
        }
        return answer;
    }

    public static void validateKubernetesMasterUrl(URL masterUrl) throws MojoExecutionException {
        if (masterUrl == null || Strings.isNullOrBlank((String)masterUrl.toString())) {
            throw new MojoExecutionException("Cannot find Kubernetes master URL. Have you started a cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`?");
        }
    }

    public static void handleKubernetesClientException(KubernetesClientException e, io.fabric8.maven.docker.util.Logger logger) throws MojoExecutionException {
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException) {
            logger.error("Could not connect to kubernetes cluster!", new Object[0]);
            logger.error("Have you started a local cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`?", new Object[0]);
            logger.info("For more help see: http://fabric8.io/guide/getStarted/", new Object[0]);
            logger.error("Connection error: %s", new Object[]{cause});
            String message = "Could not connect to kubernetes cluster. Have you started a cluster via `mvn fabric8:cluster-start` or connected to a remote cluster via `kubectl`? Error: " + cause;
            throw new MojoExecutionException(message, (Exception)((Object)e));
        }
        throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
    }

    public static <T> T findResourceByName(Iterable<HasMetadata> entities, Class<T> clazz, String name) {
        if (entities != null) {
            for (HasMetadata entity : entities) {
                if (!clazz.isInstance(entity) || !Objects.equals(name, KubernetesHelper.getName((HasMetadata)entity))) continue;
                return clazz.cast(entity);
            }
        }
        return null;
    }

    public static String getBuildStatusPhase(Build build) {
        String status = null;
        BuildStatus buildStatus = build.getStatus();
        if (buildStatus != null) {
            status = buildStatus.getPhase();
        }
        return status;
    }

    public static String getBuildStatusReason(Build build) {
        BuildStatus buildStatus = build.getStatus();
        if (buildStatus != null) {
            String reason = buildStatus.getReason();
            String phase = buildStatus.getPhase();
            if (Strings.isNotBlank((String)phase)) {
                if (Strings.isNotBlank((String)reason)) {
                    return phase + ": " + reason;
                }
                return phase;
            }
            return Strings.defaultIfEmpty((String)reason, (String)"");
        }
        return "";
    }

    public static Pod getNewestPod(Collection<Pod> pods) {
        if (pods == null || pods.isEmpty()) {
            return null;
        }
        ArrayList<Pod> sortedPods = new ArrayList<Pod>(pods);
        Collections.sort(sortedPods, new Comparator<Pod>(){

            @Override
            public int compare(Pod p1, Pod p2) {
                Date t1 = KubernetesResourceUtil.getCreationTimestamp((HasMetadata)p1);
                Date t2 = KubernetesResourceUtil.getCreationTimestamp((HasMetadata)p2);
                if (t1 != null) {
                    if (t2 == null) {
                        return 1;
                    }
                    return t1.compareTo(t2);
                }
                if (t2 == null) {
                    return 0;
                }
                return -1;
            }
        });
        return (Pod)sortedPods.get(sortedPods.size() - 1);
    }

    public static Date getCreationTimestamp(HasMetadata hasMetadata) {
        ObjectMeta metadata = hasMetadata.getMetadata();
        if (metadata != null) {
            return KubernetesResourceUtil.parseTimestamp(metadata.getCreationTimestamp());
        }
        return null;
    }

    private static Date parseTimestamp(String text) {
        if (Strings.isNullOrBlank((String)text)) {
            return null;
        }
        return KubernetesResourceUtil.parseDate(text);
    }

    public static Date parseDate(String text) {
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(text);
        }
        catch (ParseException e) {
            LOG.warn("Unable to parse date: " + text, (Throwable)e);
            return null;
        }
    }

    public static boolean podHasContainerImage(Pod pod, String imageName) {
        List containers;
        PodSpec spec;
        if (pod != null && (spec = pod.getSpec()) != null && (containers = spec.getContainers()) != null) {
            for (Container container : containers) {
                if (!io.fabric8.utils.Objects.equal((Object)imageName, (Object)container.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getDockerContainerID(Pod pod) {
        List containerStatuses;
        PodStatus status = pod.getStatus();
        if (status != null && (containerStatuses = status.getContainerStatuses()) != null) {
            for (ContainerStatus containerStatus : containerStatuses) {
                String containerID = containerStatus.getContainerID();
                if (!Strings.isNotBlank((String)containerID)) continue;
                String prefix = "://";
                int idx = containerID.indexOf(prefix);
                if (idx > 0) {
                    return containerID.substring(idx + prefix.length());
                }
                return containerID;
            }
        }
        return null;
    }

    public static boolean isNewerResource(HasMetadata newer, HasMetadata older) {
        Date t1 = KubernetesResourceUtil.getCreationTimestamp(newer);
        Date t2 = KubernetesResourceUtil.getCreationTimestamp(older);
        if (t1 != null) {
            return t2 == null || t1.compareTo(t2) > 0;
        }
        return false;
    }

    public static void mergeSimpleFields(Object targetValues, Object defaultValues) {
        Class<?> tc = targetValues.getClass();
        Class<?> sc = defaultValues.getClass();
        for (Method targetGetMethod : tc.getMethods()) {
            Class<?> fieldType;
            if (!targetGetMethod.getName().startsWith("get") || !SIMPLE_FIELD_TYPES.contains(fieldType = targetGetMethod.getReturnType())) continue;
            String fieldName = targetGetMethod.getName().substring(3);
            Method withMethod = null;
            try {
                withMethod = tc.getMethod("with" + fieldName, fieldType);
            }
            catch (NoSuchMethodException e) {
                try {
                    withMethod = tc.getMethod("set" + fieldName, fieldType);
                }
                catch (NoSuchMethodException e2) {
                    continue;
                }
            }
            Method sourceGetMethod = null;
            try {
                sourceGetMethod = sc.getMethod("get" + fieldName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                if (targetGetMethod.invoke(targetValues, new Object[0]) != null) continue;
                withMethod.invoke(targetValues, sourceGetMethod.invoke(defaultValues, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static void mergePodSpec(PodSpecBuilder builder, PodSpec defaultPodSpec, String defaultName) {
        List containers = builder.getContainers();
        List defaultContainers = defaultPodSpec.getContainers();
        int size = defaultContainers.size();
        if (size > 0) {
            if (containers == null || containers.isEmpty()) {
                builder.addToContainers(defaultContainers.toArray(new Container[size]));
            } else {
                int idx = 0;
                for (Container defaultContainer : defaultContainers) {
                    List defaultPorts;
                    Container container;
                    if (idx < containers.size()) {
                        container = (Container)containers.get(idx);
                    } else {
                        container = new Container();
                        containers.add(container);
                    }
                    KubernetesResourceUtil.mergeSimpleFields(container, defaultContainer);
                    List defaultEnv = defaultContainer.getEnv();
                    if (defaultEnv != null) {
                        for (EnvVar envVar : defaultEnv) {
                            KubernetesResourceUtil.ensureHasEnv(container, envVar);
                        }
                    }
                    if ((defaultPorts = defaultContainer.getPorts()) != null) {
                        for (ContainerPort port : defaultPorts) {
                            KubernetesResourceUtil.ensureHasPort(container, port);
                        }
                    }
                    if (container.getReadinessProbe() == null) {
                        container.setReadinessProbe(defaultContainer.getReadinessProbe());
                    }
                    if (container.getLivenessProbe() == null) {
                        container.setLivenessProbe(defaultContainer.getLivenessProbe());
                    }
                    if (container.getSecurityContext() == null) {
                        container.setSecurityContext(defaultContainer.getSecurityContext());
                    }
                    ++idx;
                }
                builder.withContainers(containers);
            }
        } else if (!containers.isEmpty()) {
            Container container = (Container)containers.get(0);
            if (Strings.isNullOrBlank((String)container.getName())) {
                container.setName(defaultName);
            }
            builder.withContainers(containers);
        }
    }

    private static void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> envVars = container.getEnv();
        if (envVars == null) {
            envVars = new ArrayList<EnvVar>();
            container.setEnv(envVars);
        }
        for (EnvVar var : envVars) {
            if (!Objects.equals(var.getName(), envVar.getName())) continue;
            return;
        }
        envVars.add(envVar);
    }

    private static void ensureHasPort(Container container, ContainerPort port) {
        ArrayList<ContainerPort> ports = container.getPorts();
        if (ports == null) {
            ports = new ArrayList<ContainerPort>();
            container.setPorts(ports);
        }
        for (ContainerPort cp : ports) {
            String n1 = cp.getName();
            String n2 = port.getName();
            if (n1 != null && n2 != null && n1.equals(n2)) {
                return;
            }
            Integer p1 = cp.getContainerPort();
            Integer p2 = port.getContainerPort();
            if (p1 == null || p2 == null || p1.intValue() != p2.intValue()) continue;
            return;
        }
        ports.add(port);
    }

    public static String getSourceUrlAnnotation(HasMetadata item) {
        return (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)item).get("maven.fabric8.io/source-url");
    }

    public static void setSourceUrlAnnotationIfNotSet(HasMetadata item, String sourceUrl) {
        Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)item);
        if (!annotations.containsKey("maven.fabric8.io/source-url")) {
            annotations.put("maven.fabric8.io/source-url", sourceUrl);
            item.getMetadata().setAnnotations(annotations);
        }
    }

    public static boolean isAppCatalogResource(HasMetadata templateOrConfigMap) {
        String catalogAnnotation = (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)templateOrConfigMap).get("maven.fabric8.io/app-catalog");
        return "true".equals(catalogAnnotation);
    }

    public static Set<HasMetadata> loadResources(File manifest) throws IOException {
        Object dto = KubernetesHelper.loadYaml((File)manifest, KubernetesResource.class);
        if (dto == null) {
            throw new IllegalStateException("Cannot load kubernetes YAML: " + manifest);
        }
        if (dto instanceof Template) {
            Template template = (Template)dto;
            boolean failOnMissingParameterValue = false;
            dto = Templates.processTemplatesLocally((Template)template, (boolean)failOnMissingParameterValue);
        }
        LinkedHashSet resources = new LinkedHashSet();
        TreeSet<HasMetadata> entities = new TreeSet<HasMetadata>((Comparator<HasMetadata>)new HasMetadataComparator());
        for (KubernetesResource resource : resources) {
            entities.addAll(KubernetesHelper.toItemList((Object)resource));
        }
        entities.addAll(KubernetesHelper.toItemList((Object)dto));
        return entities;
    }

    public static LabelSelector getPodLabelSelector(Set<HasMetadata> entities) {
        LabelSelector chosenSelector = null;
        for (HasMetadata entity : entities) {
            LabelSelector selector = KubernetesResourceUtil.getPodLabelSelector(entity);
            if (selector == null) continue;
            if (chosenSelector != null && !chosenSelector.equals((Object)selector)) {
                throw new IllegalArgumentException("Multiple selectors found for the given entities: " + chosenSelector + " - " + selector);
            }
            chosenSelector = selector;
        }
        return chosenSelector;
    }

    public static LabelSelector getPodLabelSelector(HasMetadata entity) {
        Job resource;
        JobSpec spec;
        LabelSelector selector = null;
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null) {
                selector = spec2.getSelector();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null) {
                selector = spec3.getSelector();
            }
        } else if (entity instanceof DeploymentConfig) {
            DeploymentConfig resource4 = (DeploymentConfig)entity;
            DeploymentConfigSpec spec4 = resource4.getSpec();
            if (spec4 != null) {
                selector = KubernetesResourceUtil.toLabelSelector(spec4.getSelector());
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource5 = (ReplicationController)entity;
            ReplicationControllerSpec spec5 = resource5.getSpec();
            if (spec5 != null) {
                selector = KubernetesResourceUtil.toLabelSelector(spec5.getSelector());
            }
        } else if (entity instanceof DaemonSet) {
            DaemonSet resource6 = (DaemonSet)entity;
            DaemonSetSpec spec6 = resource6.getSpec();
            if (spec6 != null) {
                selector = spec6.getSelector();
            }
        } else if (entity instanceof StatefulSet) {
            StatefulSet resource7 = (StatefulSet)entity;
            StatefulSetSpec spec7 = resource7.getSpec();
            if (spec7 != null) {
                selector = spec7.getSelector();
            }
        } else if (entity instanceof Job && (spec = (resource = (Job)entity).getSpec()) != null) {
            selector = spec.getSelector();
        }
        return selector;
    }

    private static LabelSelector toLabelSelector(Map<String, String> matchLabels) {
        if (matchLabels != null && !matchLabels.isEmpty()) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(matchLabels)).build();
        }
        return null;
    }

    static {
        for (int i = 0; i < mappings.length; i += 2) {
            FILENAME_TO_KIND_MAPPER.put(mappings[i], mappings[i + 1]);
            KIND_TO_FILENAME_MAPPER.put(mappings[i + 1], mappings[i]);
        }
    }
}

