/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.utils.Function;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcessUtil {
    public static int runCommand(Logger log, File command, List<String> args) throws IOException {
        return ProcessUtil.runCommand(log, command, args, false);
    }

    public static int runCommand(Logger log, File command, List<String> args, boolean withShutdownHook) throws IOException {
        return ProcessUtil.runAsyncCommand(log, command, args, withShutdownHook, true).await();
    }

    public static ProcessExecutionContext runAsyncCommand(Logger log, File command, List<String> args, boolean withShutdownHook, boolean useStandardLoggingLevel) throws IOException {
        String[] commandWithArgs = ProcessUtil.prepareCommandArray(command.getAbsolutePath(), args);
        Process process = Runtime.getRuntime().exec(commandWithArgs);
        if (withShutdownHook) {
            ProcessUtil.addShutdownHook(log, process, command);
        }
        List<Thread> threads = ProcessUtil.startLoggingThreads(process, log, command.getName() + " " + Strings.join(args, (String)" "), useStandardLoggingLevel);
        return new ProcessExecutionContext(process, threads, log);
    }

    private static void joinThreads(List<Thread> threads, Logger log) {
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.warn("Caught %s", new Object[]{e});
            }
        }
    }

    public static File findExecutable(Logger log, String name) {
        List<File> pathDirectories = ProcessUtil.getPathDirectories();
        for (File directory : pathDirectories) {
            String[] stringArray;
            if (EnvUtil.isWindows()) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = ".exe";
                stringArray2[1] = ".bat";
                stringArray2[2] = ".cmd";
                stringArray = stringArray2;
                stringArray2[3] = "";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            for (String extension : stringArray) {
                File file = new File(directory, name + extension);
                if (!file.exists() || !file.isFile()) continue;
                if (!file.canExecute()) {
                    log.warn("Found %s on the PATH but it is not executable. Ignoring ...", new Object[]{file});
                    continue;
                }
                return file;
            }
        }
        return null;
    }

    public static boolean folderIsOnPath(Logger logger, File dir) {
        List<File> paths = ProcessUtil.getPathDirectories();
        if (paths.size() == 0) {
            logger.warn("The $PATH environment variable is empty! Usually you have a PATH defined to find binaries.", new Object[0]);
            logger.warn("Please report this to the fabric8 team: https://github.com/fabric8io/fabric8-maven-plugin/issues/new", new Object[0]);
            return false;
        }
        for (File path : paths) {
            if (!ProcessUtil.canonicalPath(path).equals(ProcessUtil.canonicalPath(dir))) continue;
            return true;
        }
        return false;
    }

    private static void addShutdownHook(final Logger log, final Process process, final File command) {
        Runtime.getRuntime().addShutdownHook(new Thread(command.getName()){

            @Override
            public void run() {
                if (process != null) {
                    boolean alive = false;
                    try {
                        process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        alive = true;
                    }
                    if (alive) {
                        log.info("Terminating process %s", new Object[]{command});
                        try {
                            process.destroy();
                        }
                        catch (Exception e) {
                            log.error("Failed to terminate process %s", new Object[]{command});
                        }
                    }
                }
            }
        });
    }

    private static String[] prepareCommandArray(String command, List<String> args) {
        ArrayList nArgs = args != null ? args : new ArrayList();
        String[] commandWithArgs = new String[nArgs.size() + 1];
        commandWithArgs[0] = command;
        for (int i = 0; i < nArgs.size(); ++i) {
            commandWithArgs[i + 1] = (String)nArgs.get(i);
        }
        return commandWithArgs;
    }

    private static void processOutput(InputStream inputStream, Function<String, Void> function) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                function.apply((Object)line);
            }
        }
    }

    private static String canonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            String absolutePath = file.getAbsolutePath();
            return absolutePath;
        }
    }

    private static List<File> getPathDirectories() {
        ArrayList<File> pathDirectories = new ArrayList<File>();
        String pathText = System.getenv("PATH");
        if (EnvUtil.isWindows() && pathText == null) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                if (!entry.getKey().equalsIgnoreCase("PATH")) continue;
                pathText = entry.getValue();
                break;
            }
        }
        if (!Strings.isNullOrBlank((String)pathText)) {
            String[] pathTexts;
            for (String text : pathTexts = pathText.split(File.pathSeparator)) {
                File dir = new File(text);
                if (!dir.exists() || !dir.isDirectory()) continue;
                pathDirectories.add(dir);
            }
        }
        return pathDirectories;
    }

    private static List<Thread> startLoggingThreads(Process process, Logger log, String commandDesc, boolean useStandardLoggingLevel) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.add(ProcessUtil.startOutputLoggingThread(process, log, commandDesc, useStandardLoggingLevel));
        threads.add(ProcessUtil.startErrorLoggingThread(process, log, commandDesc, useStandardLoggingLevel));
        return threads;
    }

    private static Thread startErrorLoggingThread(final Process process, final Logger log, final String commandDesc, final boolean useStandardLoggingLevel) {
        Thread logThread = new Thread("[ERR] " + commandDesc){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(process.getErrorStream(), (Function<String, Void>)ProcessUtil.createErrorHandler(log, useStandardLoggingLevel));
                }
                catch (IOException e) {
                    log.error("Failed to read error stream from %s : %s", new Object[]{commandDesc, e.getMessage()});
                }
            }
        };
        logThread.setDaemon(true);
        logThread.start();
        return logThread;
    }

    private static Thread startOutputLoggingThread(final Process process, final Logger log, final String commandDesc, final boolean useStandardLoggingLevel) {
        Thread logThread = new Thread("[OUT] " + commandDesc){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(process.getInputStream(), (Function<String, Void>)ProcessUtil.createOutputHandler(log, useStandardLoggingLevel));
                }
                catch (IOException e) {
                    log.error("Failed to read output stream from %s : %s", new Object[]{commandDesc, e.getMessage()});
                }
            }
        };
        logThread.setDaemon(true);
        logThread.start();
        return logThread;
    }

    private static Function<String, Void> createOutputHandler(final Logger log, final boolean useStandardLoggingLevel) {
        return new Function<String, Void>(){

            public Void apply(String outputLine) {
                if (useStandardLoggingLevel) {
                    log.info("%s", new Object[]{outputLine});
                } else {
                    log.debug("%s", new Object[]{outputLine});
                }
                return null;
            }
        };
    }

    private static Function<String, Void> createErrorHandler(final Logger log, final boolean useStandardLoggingLevel) {
        return new Function<String, Void>(){

            public Void apply(String outputLine) {
                if (useStandardLoggingLevel) {
                    log.error("%s", new Object[]{outputLine});
                } else {
                    log.warn("%s", new Object[]{outputLine});
                }
                return null;
            }
        };
    }

    public static class ProcessExecutionContext
    implements Closeable {
        private Process process;
        private List<Thread> loggingThreads;
        private Logger log;

        public ProcessExecutionContext(Process process, List<Thread> loggingThreads, Logger log) {
            this.process = process;
            this.loggingThreads = loggingThreads;
            this.log = log;
        }

        public int await() {
            try {
                int answer = this.process.waitFor();
                ProcessUtil.joinThreads(this.loggingThreads, this.log);
                return answer;
            }
            catch (InterruptedException e) {
                return this.process.exitValue();
            }
        }

        @Override
        public void close() throws IOException {
            this.process.destroy();
            this.await();
        }
    }
}

