/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.File;

public class ClientToolsService {
    private Logger log;
    private Controller controller;

    public ClientToolsService(Controller controller, Logger log) {
        this.controller = controller;
        this.log = log;
    }

    public File getKubeCtlExecutable() {
        String missingCommandMessage;
        OpenShiftClient openShiftClient = this.controller.getOpenShiftClientOrNull();
        String command = openShiftClient != null ? "oc" : "kubectl";
        File file = ProcessUtil.findExecutable(this.log, command);
        if (file == null && command.equals("oc")) {
            file = ProcessUtil.findExecutable(this.log, command);
            missingCommandMessage = "commands oc or kubectl";
        } else {
            missingCommandMessage = "command " + command;
        }
        if (file == null) {
            throw new IllegalStateException("Could not find " + missingCommandMessage + ". Please install the necessary binaries and ensure they get added to your $PATH");
        }
        return file;
    }
}

