/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.AbstractLiveEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.enricher.api.util.GitUtil;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.URLUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class CdEnricher
extends AbstractLiveEnricher {
    public CdEnricher(EnricherContext buildContext) {
        super(buildContext, "f8-cd");
    }

    protected boolean getDefaultOnline() {
        return Systems.getEnvVarOrSystemProperty((String)"BUILD_ID") != null;
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (this.isOnline() && (kind.isDeployOrReplicaKind() || kind.isService())) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            MavenProject rootProject = MavenUtil.getRootProject((MavenProject)this.getProject());
            String repoName = rootProject.getArtifactId();
            try (Repository repository = GitUtil.getGitRepository((MavenProject)this.getProject());){
                if (repository != null) {
                    String gitCommitId = GitUtil.getGitCommitId((Repository)repository);
                    if (gitCommitId != null) {
                        this.addGitServiceUrl(annotations, repoName, gitCommitId);
                    } else {
                        this.log.debug("No Git commit id found", new Object[0]);
                    }
                } else {
                    this.log.debug("No local Git repository found", new Object[0]);
                }
            }
            catch (IOException | GitAPIException e) {
                this.log.error("Cannot extract Git information for adding to annotations: " + e, new Object[]{e});
            }
            this.addJenkinsServiceUrl(annotations, repoName);
            return annotations;
        }
        return null;
    }

    private void addGitServiceUrl(Map<String, String> annotations, String repoName, String gitCommitId) {
        String username = this.getGitUserName();
        String gogsUrl = this.getExternalServiceURL(this.getConfig(Config.gitService), "http");
        String rootGitUrl = URLUtils.pathJoin((String[])new String[]{gogsUrl, username, repoName});
        if (Strings.isNotBlank((String)(rootGitUrl = URLUtils.pathJoin((String[])new String[]{rootGitUrl, "commit", gitCommitId})))) {
            annotations.put("fabric8.io/git-url", rootGitUrl);
        }
    }

    private void addJenkinsServiceUrl(Map<String, String> annotations, String repoName) {
        String buildId = Systems.getEnvVarOrSystemProperty((String)"BUILD_ID");
        if (buildId != null) {
            annotations.put("fabric8.io/build-id", buildId);
            String serviceUrl = this.getExternalServiceURL(this.getConfig(Config.jenkinsService), "http");
            if (serviceUrl != null) {
                String jobUrl = URLUtils.pathJoin((String[])new String[]{serviceUrl, "/job", repoName});
                jobUrl = URLUtils.pathJoin((String[])new String[]{jobUrl, buildId});
                annotations.put("fabric8.io/build-url", jobUrl);
            }
        } else {
            this.log.debug("No Jenkins annotation as no BUILD_ID could be found", new Object[0]);
        }
    }

    private String getGitUserName() {
        String userEnvVar = this.getConfig(Config.gitUserEnvVar);
        String username = Systems.getEnvVarOrSystemProperty((String)userEnvVar);
        if (Strings.isNullOrBlank((String)username)) {
            username = "gogsadmin";
        }
        return username;
    }

    private static enum Config implements Configs.Key
    {
        gitService{
            {
                this.d = "gogs";
            }
        }
        ,
        jenkinsService{
            {
                this.d = "jenkins";
            }
        }
        ,
        gitUserEnvVar{
            {
                this.d = "GIT_USER";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

