/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.fabric8.AbstractHealthCheckEnricher;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KarafHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final int DEFAULT_HEALTH_CHECK_PORT = 8181;

    public KarafHealthCheckEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-healthcheck-karaf");
    }

    @Override
    protected Probe getReadinessProbe() {
        return this.discoverKarafProbe("/readiness-check", 10);
    }

    @Override
    protected Probe getLivenessProbe() {
        return this.discoverKarafProbe("/health-check", 180);
    }

    private Probe discoverKarafProbe(String path, int initialDelay) {
        Optional configurationValues = this.getContext().getConfiguration().getPluginConfiguration("maven", "karaf-maven-plugin");
        if (!configurationValues.isPresent()) {
            return null;
        }
        Optional<Object> lookup = configurationValues.map(m -> m.get("startupFeatures"));
        if (!lookup.isPresent()) {
            return null;
        }
        Object startupFeatures = lookup.get();
        if (!(startupFeatures instanceof Map)) {
            throw new IllegalArgumentException(String.format("For element %s was expected a complex object but a simple object was found of type %s and value %s", "startupFeatures", startupFeatures.getClass(), startupFeatures.toString()));
        }
        Map startUpFeaturesObject = (Map)startupFeatures;
        Object feature = startUpFeaturesObject.get("feature");
        if (feature != null) {
            if (feature instanceof List) {
                List features = (List)feature;
                for (String featureValue : features) {
                    if (!"fabric8-karaf-checks".equals(featureValue)) continue;
                    return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(Integer.valueOf(8181))).withPath(path)).endHttpGet()).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
                }
            } else {
                String featureValue = (String)feature;
                if ("fabric8-karaf-checks".equals(featureValue)) {
                    return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(Integer.valueOf(8181))).withPath(path)).endHttpGet()).withSuccessThreshold(Integer.valueOf(this.getSuccessThreshold()))).withFailureThreshold(Integer.valueOf(this.getFailureThreshold()))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
                }
            }
        }
        return null;
    }

    protected int getFailureThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.failureThreshold));
    }

    protected int getSuccessThreshold() {
        return Configs.asInteger((String)this.getConfig(Config.successThreshold));
    }

    private static enum Config implements Configs.Key
    {
        failureThreshold{
            {
                this.d = "3";
            }
        }
        ,
        successThreshold{
            {
                this.d = "1";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

