/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpec;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadEntrySpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class WorkloadEntrySpecFluentImpl<A extends WorkloadEntrySpecFluent<A>>
extends BaseFluent<A>
implements WorkloadEntrySpecFluent<A> {
    private String address;
    private Map<String, String> labels;
    private String locality;
    private String network;
    private Map<String, Long> ports;
    private String serviceAccount;
    private Integer weight;

    public WorkloadEntrySpecFluentImpl() {
    }

    public WorkloadEntrySpecFluentImpl(WorkloadEntrySpec instance) {
        this.withAddress(instance.getAddress());
        this.withLabels(instance.getLabels());
        this.withLocality(instance.getLocality());
        this.withNetwork(instance.getNetwork());
        this.withPorts(instance.getPorts());
        this.withServiceAccount(instance.getServiceAccount());
        this.withWeight(instance.getWeight());
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getLocality() {
        return this.locality;
    }

    @Override
    public A withLocality(String locality) {
        this.locality = locality;
        return (A)this;
    }

    @Override
    public Boolean hasLocality() {
        return this.locality != null;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    @Override
    public Boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public A addToPorts(String key, Long value) {
        if (this.ports == null && key != null && value != null) {
            this.ports = new LinkedHashMap<String, Long>();
        }
        if (key != null && value != null) {
            this.ports.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Map<String, Long> map) {
        if (this.ports == null && map != null) {
            this.ports = new LinkedHashMap<String, Long>();
        }
        if (map != null) {
            this.ports.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(String key) {
        if (this.ports == null) {
            return (A)this;
        }
        if (key != null && this.ports != null) {
            this.ports.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Map<String, Long> map) {
        if (this.ports == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.ports == null) continue;
                this.ports.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Long> getPorts() {
        return this.ports;
    }

    @Override
    public <K, V> A withPorts(Map<String, Long> ports) {
        this.ports = ports == null ? null : new LinkedHashMap<String, Long>(ports);
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null;
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)this;
    }

    @Override
    public Boolean hasWeight() {
        return this.weight != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadEntrySpecFluentImpl that = (WorkloadEntrySpecFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.locality != null ? !this.locality.equals(that.locality) : that.locality != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        return !(this.weight != null ? !this.weight.equals(that.weight) : that.weight != null);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.labels, this.locality, this.network, this.ports, this.serviceAccount, this.weight, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.locality != null) {
            sb.append("locality:");
            sb.append(this.locality + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight);
        }
        sb.append("}");
        return sb.toString();
    }
}

