/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.HTTPRoute;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRouteBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPRouteFluent;
import io.fabric8.istio.api.networking.v1alpha3.TCPRoute;
import io.fabric8.istio.api.networking.v1alpha3.TCPRouteBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TCPRouteFluent;
import io.fabric8.istio.api.networking.v1alpha3.TLSRoute;
import io.fabric8.istio.api.networking.v1alpha3.TLSRouteBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TLSRouteFluent;
import io.fabric8.istio.api.networking.v1alpha3.VirtualServiceSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VirtualServiceSpecFluent<A extends VirtualServiceSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> exportTo = new ArrayList<String>();
    private List<String> gateways = new ArrayList<String>();
    private List<String> hosts = new ArrayList<String>();
    private ArrayList<HTTPRouteBuilder> http = new ArrayList();
    private ArrayList<TCPRouteBuilder> tcp = new ArrayList();
    private ArrayList<TLSRouteBuilder> tls = new ArrayList();
    private Map<String, Object> additionalProperties;

    public VirtualServiceSpecFluent() {
    }

    public VirtualServiceSpecFluent(VirtualServiceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VirtualServiceSpec instance) {
        VirtualServiceSpec virtualServiceSpec = instance = instance != null ? instance : new VirtualServiceSpec();
        if (instance != null) {
            this.withExportTo(instance.getExportTo());
            this.withGateways(instance.getGateways());
            this.withHosts(instance.getHosts());
            this.withHttp(instance.getHttp());
            this.withTcp(instance.getTcp());
            this.withTls(instance.getTls());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.add(index, item);
        return (A)((Object)this);
    }

    public A setToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.set(index, item);
        return (A)((Object)this);
    }

    public A addToExportTo(String ... items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExportTo(String ... items) {
        if (this.exportTo == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.exportTo.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.exportTo.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExportTo() {
        return this.exportTo;
    }

    public String getExportTo(int index) {
        return this.exportTo.get(index);
    }

    public String getFirstExportTo() {
        return this.exportTo.get(0);
    }

    public String getLastExportTo() {
        return this.exportTo.get(this.exportTo.size() - 1);
    }

    public String getMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExportTo(List<String> exportTo) {
        if (exportTo != null) {
            this.exportTo = new ArrayList<String>();
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        } else {
            this.exportTo = null;
        }
        return (A)((Object)this);
    }

    public A withExportTo(String ... exportTo) {
        if (this.exportTo != null) {
            this.exportTo.clear();
            this._visitables.remove((Object)"exportTo");
        }
        if (exportTo != null) {
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExportTo() {
        return this.exportTo != null && !this.exportTo.isEmpty();
    }

    public A addToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.add(index, item);
        return (A)((Object)this);
    }

    public A setToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.set(index, item);
        return (A)((Object)this);
    }

    public A addToGateways(String ... items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGateways(Collection<String> items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGateways(String ... items) {
        if (this.gateways == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.gateways.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGateways(Collection<String> items) {
        if (this.gateways == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.gateways.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGateways() {
        return this.gateways;
    }

    public String getGateway(int index) {
        return this.gateways.get(index);
    }

    public String getFirstGateway() {
        return this.gateways.get(0);
    }

    public String getLastGateway() {
        return this.gateways.get(this.gateways.size() - 1);
    }

    public String getMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGateways(List<String> gateways) {
        if (gateways != null) {
            this.gateways = new ArrayList<String>();
            for (String item : gateways) {
                this.addToGateways(item);
            }
        } else {
            this.gateways = null;
        }
        return (A)((Object)this);
    }

    public A withGateways(String ... gateways) {
        if (this.gateways != null) {
            this.gateways.clear();
            this._visitables.remove((Object)"gateways");
        }
        if (gateways != null) {
            for (String item : gateways) {
                this.addToGateways(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGateways() {
        return this.gateways != null && !this.gateways.isEmpty();
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)((Object)this);
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public A addToHttp(int index, HTTPRoute item) {
        if (this.http == null) {
            this.http = new ArrayList();
        }
        HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
        if (index < 0 || index >= this.http.size()) {
            this._visitables.get((Object)"http").add(builder);
            this.http.add(builder);
        } else {
            this._visitables.get((Object)"http").add(index, builder);
            this.http.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHttp(int index, HTTPRoute item) {
        if (this.http == null) {
            this.http = new ArrayList();
        }
        HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
        if (index < 0 || index >= this.http.size()) {
            this._visitables.get((Object)"http").add(builder);
            this.http.add(builder);
        } else {
            this._visitables.get((Object)"http").set(index, builder);
            this.http.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHttp(HTTPRoute ... items) {
        if (this.http == null) {
            this.http = new ArrayList();
        }
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.get((Object)"http").add(builder);
            this.http.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHttp(Collection<HTTPRoute> items) {
        if (this.http == null) {
            this.http = new ArrayList();
        }
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.get((Object)"http").add(builder);
            this.http.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHttp(HTTPRoute ... items) {
        if (this.http == null) {
            return (A)((Object)this);
        }
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.get((Object)"http").remove((Object)builder);
            this.http.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHttp(Collection<HTTPRoute> items) {
        if (this.http == null) {
            return (A)((Object)this);
        }
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.get((Object)"http").remove((Object)builder);
            this.http.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHttp(Predicate<HTTPRouteBuilder> predicate) {
        if (this.http == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPRouteBuilder> each = this.http.iterator();
        List visitables = this._visitables.get((Object)"http");
        while (each.hasNext()) {
            HTTPRouteBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPRoute> buildHttp() {
        return this.http != null ? VirtualServiceSpecFluent.build(this.http) : null;
    }

    public HTTPRoute buildHttp(int index) {
        return this.http.get(index).build();
    }

    public HTTPRoute buildFirstHttp() {
        return this.http.get(0).build();
    }

    public HTTPRoute buildLastHttp() {
        return this.http.get(this.http.size() - 1).build();
    }

    public HTTPRoute buildMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
        for (HTTPRouteBuilder item : this.http) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
        for (HTTPRouteBuilder item : this.http) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHttp(List<HTTPRoute> http) {
        if (this.http != null) {
            this._visitables.get((Object)"http").clear();
        }
        if (http != null) {
            this.http = new ArrayList();
            for (HTTPRoute item : http) {
                this.addToHttp(item);
            }
        } else {
            this.http = null;
        }
        return (A)((Object)this);
    }

    public A withHttp(HTTPRoute ... http) {
        if (this.http != null) {
            this.http.clear();
            this._visitables.remove((Object)"http");
        }
        if (http != null) {
            for (HTTPRoute item : http) {
                this.addToHttp(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHttp() {
        return this.http != null && !this.http.isEmpty();
    }

    public HttpNested<A> addNewHttp() {
        return new HttpNested(-1, null);
    }

    public HttpNested<A> addNewHttpLike(HTTPRoute item) {
        return new HttpNested(-1, item);
    }

    public HttpNested<A> setNewHttpLike(int index, HTTPRoute item) {
        return new HttpNested(index, item);
    }

    public HttpNested<A> editHttp(int index) {
        if (this.http.size() <= index) {
            throw new RuntimeException("Can't edit http. Index exceeds size.");
        }
        return this.setNewHttpLike(index, this.buildHttp(index));
    }

    public HttpNested<A> editFirstHttp() {
        if (this.http.size() == 0) {
            throw new RuntimeException("Can't edit first http. The list is empty.");
        }
        return this.setNewHttpLike(0, this.buildHttp(0));
    }

    public HttpNested<A> editLastHttp() {
        int index = this.http.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last http. The list is empty.");
        }
        return this.setNewHttpLike(index, this.buildHttp(index));
    }

    public HttpNested<A> editMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.http.size(); ++i) {
            if (!predicate.test(this.http.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching http. No match found.");
        }
        return this.setNewHttpLike(index, this.buildHttp(index));
    }

    public A addToTcp(int index, TCPRoute item) {
        if (this.tcp == null) {
            this.tcp = new ArrayList();
        }
        TCPRouteBuilder builder = new TCPRouteBuilder(item);
        if (index < 0 || index >= this.tcp.size()) {
            this._visitables.get((Object)"tcp").add(builder);
            this.tcp.add(builder);
        } else {
            this._visitables.get((Object)"tcp").add(index, builder);
            this.tcp.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTcp(int index, TCPRoute item) {
        if (this.tcp == null) {
            this.tcp = new ArrayList();
        }
        TCPRouteBuilder builder = new TCPRouteBuilder(item);
        if (index < 0 || index >= this.tcp.size()) {
            this._visitables.get((Object)"tcp").add(builder);
            this.tcp.add(builder);
        } else {
            this._visitables.get((Object)"tcp").set(index, builder);
            this.tcp.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTcp(TCPRoute ... items) {
        if (this.tcp == null) {
            this.tcp = new ArrayList();
        }
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.get((Object)"tcp").add(builder);
            this.tcp.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTcp(Collection<TCPRoute> items) {
        if (this.tcp == null) {
            this.tcp = new ArrayList();
        }
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.get((Object)"tcp").add(builder);
            this.tcp.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTcp(TCPRoute ... items) {
        if (this.tcp == null) {
            return (A)((Object)this);
        }
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.get((Object)"tcp").remove((Object)builder);
            this.tcp.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTcp(Collection<TCPRoute> items) {
        if (this.tcp == null) {
            return (A)((Object)this);
        }
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.get((Object)"tcp").remove((Object)builder);
            this.tcp.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTcp(Predicate<TCPRouteBuilder> predicate) {
        if (this.tcp == null) {
            return (A)((Object)this);
        }
        Iterator<TCPRouteBuilder> each = this.tcp.iterator();
        List visitables = this._visitables.get((Object)"tcp");
        while (each.hasNext()) {
            TCPRouteBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TCPRoute> buildTcp() {
        return this.tcp != null ? VirtualServiceSpecFluent.build(this.tcp) : null;
    }

    public TCPRoute buildTcp(int index) {
        return this.tcp.get(index).build();
    }

    public TCPRoute buildFirstTcp() {
        return this.tcp.get(0).build();
    }

    public TCPRoute buildLastTcp() {
        return this.tcp.get(this.tcp.size() - 1).build();
    }

    public TCPRoute buildMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
        for (TCPRouteBuilder item : this.tcp) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
        for (TCPRouteBuilder item : this.tcp) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTcp(List<TCPRoute> tcp) {
        if (this.tcp != null) {
            this._visitables.get((Object)"tcp").clear();
        }
        if (tcp != null) {
            this.tcp = new ArrayList();
            for (TCPRoute item : tcp) {
                this.addToTcp(item);
            }
        } else {
            this.tcp = null;
        }
        return (A)((Object)this);
    }

    public A withTcp(TCPRoute ... tcp) {
        if (this.tcp != null) {
            this.tcp.clear();
            this._visitables.remove((Object)"tcp");
        }
        if (tcp != null) {
            for (TCPRoute item : tcp) {
                this.addToTcp(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTcp() {
        return this.tcp != null && !this.tcp.isEmpty();
    }

    public TcpNested<A> addNewTcp() {
        return new TcpNested(-1, null);
    }

    public TcpNested<A> addNewTcpLike(TCPRoute item) {
        return new TcpNested(-1, item);
    }

    public TcpNested<A> setNewTcpLike(int index, TCPRoute item) {
        return new TcpNested(index, item);
    }

    public TcpNested<A> editTcp(int index) {
        if (this.tcp.size() <= index) {
            throw new RuntimeException("Can't edit tcp. Index exceeds size.");
        }
        return this.setNewTcpLike(index, this.buildTcp(index));
    }

    public TcpNested<A> editFirstTcp() {
        if (this.tcp.size() == 0) {
            throw new RuntimeException("Can't edit first tcp. The list is empty.");
        }
        return this.setNewTcpLike(0, this.buildTcp(0));
    }

    public TcpNested<A> editLastTcp() {
        int index = this.tcp.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tcp. The list is empty.");
        }
        return this.setNewTcpLike(index, this.buildTcp(index));
    }

    public TcpNested<A> editMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tcp.size(); ++i) {
            if (!predicate.test(this.tcp.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tcp. No match found.");
        }
        return this.setNewTcpLike(index, this.buildTcp(index));
    }

    public A addToTls(int index, TLSRoute item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        TLSRouteBuilder builder = new TLSRouteBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get((Object)"tls").add(index, builder);
            this.tls.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTls(int index, TLSRoute item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        TLSRouteBuilder builder = new TLSRouteBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get((Object)"tls").set(index, builder);
            this.tls.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTls(TLSRoute ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (TLSRoute item : items) {
            TLSRouteBuilder builder = new TLSRouteBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTls(Collection<TLSRoute> items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (TLSRoute item : items) {
            TLSRouteBuilder builder = new TLSRouteBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTls(TLSRoute ... items) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        for (TLSRoute item : items) {
            TLSRouteBuilder builder = new TLSRouteBuilder(item);
            this._visitables.get((Object)"tls").remove((Object)builder);
            this.tls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTls(Collection<TLSRoute> items) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        for (TLSRoute item : items) {
            TLSRouteBuilder builder = new TLSRouteBuilder(item);
            this._visitables.get((Object)"tls").remove((Object)builder);
            this.tls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTls(Predicate<TLSRouteBuilder> predicate) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        Iterator<TLSRouteBuilder> each = this.tls.iterator();
        List visitables = this._visitables.get((Object)"tls");
        while (each.hasNext()) {
            TLSRouteBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TLSRoute> buildTls() {
        return this.tls != null ? VirtualServiceSpecFluent.build(this.tls) : null;
    }

    public TLSRoute buildTl(int index) {
        return this.tls.get(index).build();
    }

    public TLSRoute buildFirstTl() {
        return this.tls.get(0).build();
    }

    public TLSRoute buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    public TLSRoute buildMatchingTl(Predicate<TLSRouteBuilder> predicate) {
        for (TLSRouteBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTl(Predicate<TLSRouteBuilder> predicate) {
        for (TLSRouteBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTls(List<TLSRoute> tls) {
        if (this.tls != null) {
            this._visitables.get((Object)"tls").clear();
        }
        if (tls != null) {
            this.tls = new ArrayList();
            for (TLSRoute item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)((Object)this);
    }

    public A withTls(TLSRoute ... tls) {
        if (this.tls != null) {
            this.tls.clear();
            this._visitables.remove((Object)"tls");
        }
        if (tls != null) {
            for (TLSRoute item : tls) {
                this.addToTls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    public TlsNested<A> addNewTl() {
        return new TlsNested(-1, null);
    }

    public TlsNested<A> addNewTlLike(TLSRoute item) {
        return new TlsNested(-1, item);
    }

    public TlsNested<A> setNewTlLike(int index, TLSRoute item) {
        return new TlsNested(index, item);
    }

    public TlsNested<A> editTl(int index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    public TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editMatchingTl(Predicate<TLSRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualServiceSpecFluent that = (VirtualServiceSpecFluent)((Object)o);
        if (!Objects.equals(this.exportTo, that.exportTo)) {
            return false;
        }
        if (!Objects.equals(this.gateways, that.gateways)) {
            return false;
        }
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        if (!Objects.equals(this.http, that.http)) {
            return false;
        }
        if (!Objects.equals(this.tcp, that.tcp)) {
            return false;
        }
        if (!Objects.equals(this.tls, that.tls)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.exportTo, this.gateways, this.hosts, this.http, this.tcp, this.tls, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exportTo != null && !this.exportTo.isEmpty()) {
            sb.append("exportTo:");
            sb.append(this.exportTo + ",");
        }
        if (this.gateways != null && !this.gateways.isEmpty()) {
            sb.append("gateways:");
            sb.append(this.gateways + ",");
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.http != null && !this.http.isEmpty()) {
            sb.append("http:");
            sb.append(this.http + ",");
        }
        if (this.tcp != null && !this.tcp.isEmpty()) {
            sb.append("tcp:");
            sb.append(this.tcp + ",");
        }
        if (this.tls != null && !this.tls.isEmpty()) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsNested<N>
    extends TLSRouteFluent<TlsNested<N>>
    implements Nested<N> {
        TLSRouteBuilder builder;
        int index;

        TlsNested(int index, TLSRoute item) {
            this.index = index;
            this.builder = new TLSRouteBuilder(this, item);
        }

        public N and() {
            return (N)VirtualServiceSpecFluent.this.setToTls(this.index, this.builder.build());
        }

        public N endTl() {
            return this.and();
        }
    }

    public class TcpNested<N>
    extends TCPRouteFluent<TcpNested<N>>
    implements Nested<N> {
        TCPRouteBuilder builder;
        int index;

        TcpNested(int index, TCPRoute item) {
            this.index = index;
            this.builder = new TCPRouteBuilder(this, item);
        }

        public N and() {
            return (N)VirtualServiceSpecFluent.this.setToTcp(this.index, this.builder.build());
        }

        public N endTcp() {
            return this.and();
        }
    }

    public class HttpNested<N>
    extends HTTPRouteFluent<HttpNested<N>>
    implements Nested<N> {
        HTTPRouteBuilder builder;
        int index;

        HttpNested(int index, HTTPRoute item) {
            this.index = index;
            this.builder = new HTTPRouteBuilder(this, item);
        }

        public N and() {
            return (N)VirtualServiceSpecFluent.this.setToHttp(this.index, this.builder.build());
        }

        public N endHttp() {
            return this.and();
        }
    }
}

