/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.serving.v1.ContainerStatus;
import io.fabric8.knative.serving.v1.ContainerStatusBuilder;
import io.fabric8.knative.serving.v1.ContainerStatusFluent;
import io.fabric8.knative.serving.v1.RevisionStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RevisionStatusFluent<A extends RevisionStatusFluent<A>>
extends BaseFluent<A> {
    private Integer actualReplicas;
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList();
    private Integer desiredReplicas;
    private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList();
    private String logUrl;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public RevisionStatusFluent() {
    }

    public RevisionStatusFluent(RevisionStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RevisionStatus instance) {
        RevisionStatus revisionStatus = instance = instance != null ? instance : new RevisionStatus();
        if (instance != null) {
            this.withActualReplicas(instance.getActualReplicas());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withContainerStatuses(instance.getContainerStatuses());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withInitContainerStatuses(instance.getInitContainerStatuses());
            this.withLogUrl(instance.getLogUrl());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getActualReplicas() {
        return this.actualReplicas;
    }

    public A withActualReplicas(Integer actualReplicas) {
        this.actualReplicas = actualReplicas;
        return (A)((Object)this);
    }

    public boolean hasActualReplicas() {
        return this.actualReplicas != null;
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? RevisionStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"containerStatuses").add(index, builder);
            this.containerStatuses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"containerStatuses").set(index, builder);
            this.containerStatuses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            return (A)((Object)this);
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").remove((Object)builder);
            this.containerStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            return (A)((Object)this);
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").remove((Object)builder);
            this.containerStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerStatusBuilder> each = this.containerStatuses.iterator();
        List visitables = this._visitables.get((Object)"containerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerStatus> buildContainerStatuses() {
        return this.containerStatuses != null ? RevisionStatusFluent.build(this.containerStatuses) : null;
    }

    public ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get((Object)"containerStatuses").clear();
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList();
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)((Object)this);
    }

    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
            this._visitables.remove((Object)"containerStatuses");
        }
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    public A addNewContainerStatus(String imageDigest, String name) {
        return this.addToContainerStatuses(new ContainerStatus(imageDigest, name));
    }

    public ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNested(-1, null);
    }

    public ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNested(-1, item);
    }

    public ContainerStatusesNested<A> setNewContainerStatusLike(int index, ContainerStatus item) {
        return new ContainerStatusesNested(index, item);
    }

    public ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    public ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)((Object)this);
    }

    public boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    public A addToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"initContainerStatuses").add(index, builder);
            this.initContainerStatuses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"initContainerStatuses").set(index, builder);
            this.initContainerStatuses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            return (A)((Object)this);
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").remove((Object)builder);
            this.initContainerStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            return (A)((Object)this);
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").remove((Object)builder);
            this.initContainerStatuses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        List visitables = this._visitables.get((Object)"initContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerStatus> buildInitContainerStatuses() {
        return this.initContainerStatuses != null ? RevisionStatusFluent.build(this.initContainerStatuses) : null;
    }

    public ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    public ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get((Object)"initContainerStatuses").clear();
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList();
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)((Object)this);
    }

    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
            this._visitables.remove((Object)"initContainerStatuses");
        }
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    public A addNewInitContainerStatus(String imageDigest, String name) {
        return this.addToInitContainerStatuses(new ContainerStatus(imageDigest, name));
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNested(-1, null);
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNested(-1, item);
    }

    public InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, ContainerStatus item) {
        return new InitContainerStatusesNested(index, item);
    }

    public InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    public InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.test(this.initContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public A withLogUrl(String logUrl) {
        this.logUrl = logUrl;
        return (A)((Object)this);
    }

    public boolean hasLogUrl() {
        return this.logUrl != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionStatusFluent that = (RevisionStatusFluent)((Object)o);
        if (!Objects.equals(this.actualReplicas, that.actualReplicas)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.containerStatuses, that.containerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.initContainerStatuses, that.initContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.logUrl, that.logUrl)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.actualReplicas, this.annotations, this.conditions, this.containerStatuses, this.desiredReplicas, this.initContainerStatuses, this.logUrl, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actualReplicas != null) {
            sb.append("actualReplicas:");
            sb.append(this.actualReplicas + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.containerStatuses != null && !this.containerStatuses.isEmpty()) {
            sb.append("containerStatuses:");
            sb.append(this.containerStatuses + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty()) {
            sb.append("initContainerStatuses:");
            sb.append(this.initContainerStatuses + ",");
        }
        if (this.logUrl != null) {
            sb.append("logUrl:");
            sb.append(this.logUrl + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class InitContainerStatusesNested<N>
    extends ContainerStatusFluent<InitContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        InitContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        public N and() {
            return (N)RevisionStatusFluent.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class ContainerStatusesNested<N>
    extends ContainerStatusFluent<ContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        ContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        public N and() {
            return (N)RevisionStatusFluent.this.setToContainerStatuses(this.index, this.builder.build());
        }

        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)RevisionStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

