/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.autoscaling.v1alpha1;

import io.fabric8.knative.internal.autoscaling.v1alpha1.PodAutoscalerSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.Objects;
import java.util.Optional;

public class PodAutoscalerSpecFluent<A extends PodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Long containerConcurrency;
    private String protocolType;
    private String reachability;
    private ObjectReferenceBuilder scaleTargetRef;

    public PodAutoscalerSpecFluent() {
    }

    public PodAutoscalerSpecFluent(PodAutoscalerSpec instance) {
        PodAutoscalerSpec podAutoscalerSpec = instance = instance != null ? instance : new PodAutoscalerSpec();
        if (instance != null) {
            this.withContainerConcurrency(instance.getContainerConcurrency());
            this.withProtocolType(instance.getProtocolType());
            this.withReachability(instance.getReachability());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withContainerConcurrency(instance.getContainerConcurrency());
            this.withProtocolType(instance.getProtocolType());
            this.withReachability(instance.getReachability());
            this.withScaleTargetRef(instance.getScaleTargetRef());
        }
    }

    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)((Object)this);
    }

    public boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public A withProtocolType(String protocolType) {
        this.protocolType = protocolType;
        return (A)((Object)this);
    }

    public boolean hasProtocolType() {
        return this.protocolType != null;
    }

    public String getReachability() {
        return this.reachability;
    }

    public A withReachability(String reachability) {
        this.reachability = reachability;
        return (A)((Object)this);
    }

    public boolean hasReachability() {
        return this.reachability != null;
    }

    public ObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(ObjectReference scaleTargetRef) {
        this._visitables.get((Object)"scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new ObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get((Object)"scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get((Object)"scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)((Object)this);
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(ObjectReference item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(ObjectReference item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodAutoscalerSpecFluent that = (PodAutoscalerSpecFluent)((Object)o);
        if (!Objects.equals(this.containerConcurrency, that.containerConcurrency)) {
            return false;
        }
        if (!Objects.equals(this.protocolType, that.protocolType)) {
            return false;
        }
        if (!Objects.equals(this.reachability, that.reachability)) {
            return false;
        }
        return Objects.equals(this.scaleTargetRef, that.scaleTargetRef);
    }

    public int hashCode() {
        return Objects.hash(this.containerConcurrency, this.protocolType, this.reachability, this.scaleTargetRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerConcurrency != null) {
            sb.append("containerConcurrency:");
            sb.append(this.containerConcurrency + ",");
        }
        if (this.protocolType != null) {
            sb.append("protocolType:");
            sb.append(this.protocolType + ",");
        }
        if (this.reachability != null) {
            sb.append("reachability:");
            sb.append(this.reachability + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends ObjectReferenceFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ScaleTargetRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PodAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

