package io.fabric8.kubernetes.client.extended.run;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class RunConfigFluentImpl<A extends io.fabric8.kubernetes.client.extended.run.RunConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.client.extended.run.RunConfigFluent<A>{
  public RunConfigFluentImpl() {
  }
  public RunConfigFluentImpl(io.fabric8.kubernetes.client.extended.run.RunConfig instance) {
    this.withName(instance.getName()); 
    this.withImage(instance.getImage()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withCommand(instance.getCommand()); 
    this.withArgs(instance.getArgs()); 
    this.withRestartPolicy(instance.getRestartPolicy()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withLabels(instance.getLabels()); 
    this.withEnv(instance.getEnv()); 
    this.withLimits(instance.getLimits()); 
    this.withRequests(instance.getRequests()); 
    this.withPort(instance.getPort()); 
  }
  private java.lang.String name;
  private java.lang.String image;
  private java.lang.String imagePullPolicy;
  private java.lang.String command;
  private java.util.List<java.lang.String> args;
  private java.lang.String restartPolicy;
  private java.lang.String serviceAccount;
  private java.util.Map<java.lang.String,java.lang.String> labels;
  private java.util.Map<java.lang.String,java.lang.String> env;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> limits;
  private java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> requests;
  private int port;
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  public java.lang.String getImage() {
    return this.image;
  }
  public A withImage(java.lang.String image) {
    this.image=image; return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  
  /**
   * Method is deprecated. use withImage instead.
   */
  @java.lang.Deprecated
  public A withNewImage(java.lang.String arg0) {
    return (A)withImage(new String(arg0));
  }
  public java.lang.String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  public A withImagePullPolicy(java.lang.String imagePullPolicy) {
    this.imagePullPolicy=imagePullPolicy; return (A) this;
  }
  public java.lang.Boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  /**
   * Method is deprecated. use withImagePullPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewImagePullPolicy(java.lang.String arg0) {
    return (A)withImagePullPolicy(new String(arg0));
  }
  public java.lang.String getCommand() {
    return this.command;
  }
  public A withCommand(java.lang.String command) {
    this.command=command; return (A) this;
  }
  public java.lang.Boolean hasCommand() {
    return this.command != null;
  }
  
  /**
   * Method is deprecated. use withCommand instead.
   */
  @java.lang.Deprecated
  public A withNewCommand(java.lang.String arg0) {
    return (A)withCommand(new String(arg0));
  }
  public A addToArgs(java.lang.Integer index,java.lang.String item) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    this.args.add(index, item);
    return (A)this;
  }
  public A setToArgs(java.lang.Integer index,java.lang.String item) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    this.args.set(index, item); return (A)this;
  }
  public A addToArgs(java.lang.String... items) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.args.add(item);} return (A)this;
  }
  public A addAllToArgs(java.util.Collection<java.lang.String> items) {
    if (this.args == null) {this.args = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.args.add(item);} return (A)this;
  }
  public A removeFromArgs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public A removeAllFromArgs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getArgs() {
    return this.args;
  }
  public java.lang.String getArg(java.lang.Integer index) {
    return this.args.get(index);
  }
  public java.lang.String getFirstArg() {
    return this.args.get(0);
  }
  public java.lang.String getLastArg() {
    return this.args.get(args.size() - 1);
  }
  public java.lang.String getMatchingArg(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: args) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingArg(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: args) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArgs(java.util.List<java.lang.String> args) {
    if (args != null) {this.args = new java.util.ArrayList(); for (java.lang.String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
  }
  public A withArgs(java.lang.String... args) {
    if (this.args != null) {this.args.clear();}
    if (args != null) {for (java.lang.String item :args){ this.addToArgs(item);}} return (A) this;
  }
  public java.lang.Boolean hasArgs() {
    return args != null && !args.isEmpty();
  }
  public A addNewArg(java.lang.String arg0) {
    return (A)addToArgs(new String(arg0));
  }
  public java.lang.String getRestartPolicy() {
    return this.restartPolicy;
  }
  public A withRestartPolicy(java.lang.String restartPolicy) {
    this.restartPolicy=restartPolicy; return (A) this;
  }
  public java.lang.Boolean hasRestartPolicy() {
    return this.restartPolicy != null;
  }
  
  /**
   * Method is deprecated. use withRestartPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewRestartPolicy(java.lang.String arg0) {
    return (A)withRestartPolicy(new String(arg0));
  }
  public java.lang.String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(java.lang.String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public java.lang.Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  /**
   * Method is deprecated. use withServiceAccount instead.
   */
  @java.lang.Deprecated
  public A withNewServiceAccount(java.lang.String arg0) {
    return (A)withServiceAccount(new String(arg0));
  }
  public A addToLabels(java.lang.String key,java.lang.String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.labels == null && map != null) { this.labels = new java.util.LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(java.lang.String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(java.util.Map<java.lang.String,java.lang.String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new java.util.LinkedHashMap(labels);} return (A) this;
  }
  public java.lang.Boolean hasLabels() {
    return this.labels != null;
  }
  public A addToEnv(java.lang.String key,java.lang.String value) {
    if(this.env == null && key != null && value != null) { this.env = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.env.put(key, value);} return (A)this;
  }
  public A addToEnv(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.env == null && map != null) { this.env = new java.util.LinkedHashMap(); }
    if(map != null) { this.env.putAll(map);} return (A)this;
  }
  public A removeFromEnv(java.lang.String key) {
    if(this.env == null) { return (A) this; }
    if(key != null && this.env != null) {this.env.remove(key);} return (A)this;
  }
  public A removeFromEnv(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.env == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.env != null){this.env.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getEnv() {
    return this.env;
  }
  public <K,V>A withEnv(java.util.Map<java.lang.String,java.lang.String> env) {
    if (env == null) { this.env =  null;} else {this.env = new java.util.LinkedHashMap(env);} return (A) this;
  }
  public java.lang.Boolean hasEnv() {
    return this.env != null;
  }
  public A addToLimits(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.limits == null && key != null && value != null) { this.limits = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.limits.put(key, value);} return (A)this;
  }
  public A addToLimits(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.limits == null && map != null) { this.limits = new java.util.LinkedHashMap(); }
    if(map != null) { this.limits.putAll(map);} return (A)this;
  }
  public A removeFromLimits(java.lang.String key) {
    if(this.limits == null) { return (A) this; }
    if(key != null && this.limits != null) {this.limits.remove(key);} return (A)this;
  }
  public A removeFromLimits(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.limits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.limits != null){this.limits.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getLimits() {
    return this.limits;
  }
  public <K,V>A withLimits(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> limits) {
    if (limits == null) { this.limits =  null;} else {this.limits = new java.util.LinkedHashMap(limits);} return (A) this;
  }
  public java.lang.Boolean hasLimits() {
    return this.limits != null;
  }
  public A addToRequests(java.lang.String key,io.fabric8.kubernetes.api.model.Quantity value) {
    if(this.requests == null && key != null && value != null) { this.requests = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.requests.put(key, value);} return (A)this;
  }
  public A addToRequests(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.requests == null && map != null) { this.requests = new java.util.LinkedHashMap(); }
    if(map != null) { this.requests.putAll(map);} return (A)this;
  }
  public A removeFromRequests(java.lang.String key) {
    if(this.requests == null) { return (A) this; }
    if(key != null && this.requests != null) {this.requests.remove(key);} return (A)this;
  }
  public A removeFromRequests(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map) {
    if(this.requests == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.requests != null){this.requests.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getRequests() {
    return this.requests;
  }
  public <K,V>A withRequests(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> requests) {
    if (requests == null) { this.requests =  null;} else {this.requests = new java.util.LinkedHashMap(requests);} return (A) this;
  }
  public java.lang.Boolean hasRequests() {
    return this.requests != null;
  }
  public int getPort() {
    return this.port;
  }
  public A withPort(int port) {
    this.port=port; return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return true;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RunConfigFluentImpl that = (RunConfigFluentImpl) o;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
    if (command != null ? !command.equals(that.command) :that.command != null) return false;
    if (args != null ? !args.equals(that.args) :that.args != null) return false;
    if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
    if (requests != null ? !requests.equals(that.requests) :that.requests != null) return false;
    if (port != that.port) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  image,  imagePullPolicy,  command,  args,  restartPolicy,  serviceAccount,  labels,  env,  limits,  requests,  port,  super.hashCode());
  }
  
}