
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventBuilder;
import io.fabric8.kubernetes.api.model.EventList;

import java.util.Map;
import java.util.TreeMap;


public class EventOperationsImpl extends HasMetadataOperation<Event, EventList, Resource<Event>> {

  public EventOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public EventOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public EventOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("events"));
    this.type = Event.class;
    this.listType = EventList.class;
  }

  public EventOperationsImpl newInstance(OperationContext context) {
    return new EventOperationsImpl(context);
  }

  @Override
  public Event edit(Visitor... visitors) {
    return patch(new EventBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
