
                                          

package io.fabric8.kubernetes.client.handlers.apps.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;

public class StatefulSetHandler implements ResourceHandler<StatefulSet, StatefulSetBuilder> {

  @Override
  public String getKind() {
    return StatefulSet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apps/v1";
      }

  @Override
  public StatefulSetBuilder edit(StatefulSet item) {
    return new StatefulSetBuilder(item);
  }

  @Override
  public Resource<StatefulSet> resource(OkHttpClient client, Config config, String namespace, StatefulSet item) {
    return new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
