
                                          

package io.fabric8.kubernetes.client.handlers.autoscaling.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.autoscaling.v1.HorizontalPodAutoscalerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerBuilder;

public class HorizontalPodAutoscalerHandler implements ResourceHandler<HorizontalPodAutoscaler, HorizontalPodAutoscalerBuilder> {

  @Override
  public String getKind() {
    return HorizontalPodAutoscaler.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "autoscaling/v1";
      }

  @Override
  public HorizontalPodAutoscalerBuilder edit(HorizontalPodAutoscaler item) {
    return new HorizontalPodAutoscalerBuilder(item);
  }

  @Override
  public Resource<HorizontalPodAutoscaler> resource(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
