
                                          

package io.fabric8.kubernetes.client.handlers.certificates.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.certificates.v1.CertificateSigningRequestOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestBuilder;

public class CertificateSigningRequestHandler implements ResourceHandler<CertificateSigningRequest, CertificateSigningRequestBuilder> {

  @Override
  public String getKind() {
    return CertificateSigningRequest.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "certificates.k8s.io/v1";
      }

  @Override
  public CertificateSigningRequestBuilder edit(CertificateSigningRequest item) {
    return new CertificateSigningRequestBuilder(item);
  }

  @Override
  public Resource<CertificateSigningRequest> resource(OkHttpClient client, Config config, String namespace, CertificateSigningRequest item) {
    return new CertificateSigningRequestOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
