
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.APIServiceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.APIService;
import io.fabric8.kubernetes.api.model.APIServiceBuilder;

public class APIServiceHandler implements ResourceHandler<APIService, APIServiceBuilder> {

  @Override
  public String getKind() {
    return APIService.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apiregistration.k8s.io/v1";
      }

  @Override
  public APIServiceBuilder edit(APIService item) {
    return new APIServiceBuilder(item);
  }

  @Override
  public Resource<APIService> resource(OkHttpClient client, Config config, String namespace, APIService item) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
