
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.EndpointsOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;

public class EndpointsHandler implements ResourceHandler<Endpoints, EndpointsBuilder> {

  @Override
  public String getKind() {
    return Endpoints.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public EndpointsBuilder edit(Endpoints item) {
    return new EndpointsBuilder(item);
  }

  @Override
  public Resource<Endpoints> resource(OkHttpClient client, Config config, String namespace, Endpoints item) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
