
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.NamespaceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;

public class NamespaceHandler implements ResourceHandler<Namespace, NamespaceBuilder> {

  @Override
  public String getKind() {
    return Namespace.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public NamespaceBuilder edit(Namespace item) {
    return new NamespaceBuilder(item);
  }

  @Override
  public Resource<Namespace> resource(OkHttpClient client, Config config, String namespace, Namespace item) {
    return new NamespaceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
