
                                          

package io.fabric8.kubernetes.client.handlers.discovery.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.discovery.v1beta1.EndpointSliceOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceBuilder;

public class EndpointSliceHandler implements ResourceHandler<EndpointSlice, EndpointSliceBuilder> {

  @Override
  public String getKind() {
    return EndpointSlice.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "discovery.k8s.io/v1beta1";
      }

  @Override
  public EndpointSliceBuilder edit(EndpointSlice item) {
    return new EndpointSliceBuilder(item);
  }

  @Override
  public Resource<EndpointSlice> resource(OkHttpClient client, Config config, String namespace, EndpointSlice item) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
