
                                          

package io.fabric8.kubernetes.client.handlers.metrics.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.metrics.v1beta1.PodMetricsOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsBuilder;

public class PodMetricsHandler implements ResourceHandler<PodMetrics, PodMetricsBuilder> {

  @Override
  public String getKind() {
    return PodMetrics.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "metrics.k8s.io/v1beta1";
      }

  @Override
  public PodMetricsBuilder edit(PodMetrics item) {
    return new PodMetricsBuilder(item);
  }

  @Override
  public Resource<PodMetrics> resource(OkHttpClient client, Config config, String namespace, PodMetrics item) {
    return new PodMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
