package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SubjectAccessReviewSpecFluentImpl<A extends SubjectAccessReviewSpecFluent<A>> extends BaseFluent<A> implements SubjectAccessReviewSpecFluent<A>{
  public SubjectAccessReviewSpecFluentImpl() {
  }
  public SubjectAccessReviewSpecFluentImpl(SubjectAccessReviewSpec instance) {
    this.withExtra(instance.getExtra()); 
    this.withGroup(instance.getGroup()); 
    this.withNonResourceAttributes(instance.getNonResourceAttributes()); 
    this.withResourceAttributes(instance.getResourceAttributes()); 
    this.withUid(instance.getUid()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Map<String,ArrayList<String>> extra;
  private List<String> group = new ArrayList<String>();
  private NonResourceAttributesBuilder nonResourceAttributes;
  private ResourceAttributesBuilder resourceAttributes;
  private String uid;
  private String user;
  private Map<String,Object> additionalProperties;
  public A addToExtra(String key,ArrayList<String> value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  public A addToExtra(Map<String,ArrayList<String>> map) {
    if(this.extra == null && map != null) { this.extra = new LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  public A removeFromExtra(String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  public A removeFromExtra(Map<String,ArrayList<String>> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  public Map<String,ArrayList<String>> getExtra() {
    return this.extra;
  }
  public <K,V>A withExtra(Map<String,ArrayList<String>> extra) {
    if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap(extra);} return (A) this;
  }
  public Boolean hasExtra() {
    return this.extra != null;
  }
  public A addToGroup(Integer index,String item) {
    if (this.group == null) {this.group = new ArrayList<String>();}
    this.group.add(index, item);
    return (A)this;
  }
  public A setToGroup(Integer index,String item) {
    if (this.group == null) {this.group = new ArrayList<String>();}
    this.group.set(index, item); return (A)this;
  }
  public A addToGroup(java.lang.String... items) {
    if (this.group == null) {this.group = new ArrayList<String>();}
    for (String item : items) {this.group.add(item);} return (A)this;
  }
  public A addAllToGroup(Collection<String> items) {
    if (this.group == null) {this.group = new ArrayList<String>();}
    for (String item : items) {this.group.add(item);} return (A)this;
  }
  public A removeFromGroup(java.lang.String... items) {
    for (String item : items) {if (this.group!= null){ this.group.remove(item);}} return (A)this;
  }
  public A removeAllFromGroup(Collection<String> items) {
    for (String item : items) {if (this.group!= null){ this.group.remove(item);}} return (A)this;
  }
  public List<String> getGroup() {
    return this.group;
  }
  public String getGroup(Integer index) {
    return this.group.get(index);
  }
  public String getFirstGroup() {
    return this.group.get(0);
  }
  public String getLastGroup() {
    return this.group.get(group.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: group) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: group) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroup(List<String> group) {
    if (group != null) {this.group = new ArrayList(); for (String item : group){this.addToGroup(item);}} else { this.group = null;} return (A) this;
  }
  public A withGroup(java.lang.String... group) {
    if (this.group != null) {this.group.clear();}
    if (group != null) {for (String item :group){ this.addToGroup(item);}} return (A) this;
  }
  public Boolean hasGroup() {
    return group != null && !group.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildNonResourceAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public NonResourceAttributes getNonResourceAttributes() {
    return this.nonResourceAttributes!=null ?this.nonResourceAttributes.build():null;
  }
  public NonResourceAttributes buildNonResourceAttributes() {
    return this.nonResourceAttributes!=null ?this.nonResourceAttributes.build():null;
  }
  public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
    _visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
    if (nonResourceAttributes!=null){ this.nonResourceAttributes= new NonResourceAttributesBuilder(nonResourceAttributes); _visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);} else { this.nonResourceAttributes = null; _visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes); } return (A) this;
  }
  public Boolean hasNonResourceAttributes() {
    return this.nonResourceAttributes != null;
  }
  public A withNewNonResourceAttributes(String path,String verb) {
    return (A)withNonResourceAttributes(new NonResourceAttributes(path, verb));
  }
  public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
    return new SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNestedImpl();
  }
  public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
    return new SubjectAccessReviewSpecFluentImpl.NonResourceAttributesNestedImpl(item);
  }
  public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes() {
    return withNewNonResourceAttributesLike(getNonResourceAttributes());
  }
  public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
    return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): new NonResourceAttributesBuilder().build());
  }
  public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
    return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResourceAttributes instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceAttributes getResourceAttributes() {
    return this.resourceAttributes!=null ?this.resourceAttributes.build():null;
  }
  public ResourceAttributes buildResourceAttributes() {
    return this.resourceAttributes!=null ?this.resourceAttributes.build():null;
  }
  public A withResourceAttributes(ResourceAttributes resourceAttributes) {
    _visitables.get("resourceAttributes").remove(this.resourceAttributes);
    if (resourceAttributes!=null){ this.resourceAttributes= new ResourceAttributesBuilder(resourceAttributes); _visitables.get("resourceAttributes").add(this.resourceAttributes);} else { this.resourceAttributes = null; _visitables.get("resourceAttributes").remove(this.resourceAttributes); } return (A) this;
  }
  public Boolean hasResourceAttributes() {
    return this.resourceAttributes != null;
  }
  public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes() {
    return new SubjectAccessReviewSpecFluentImpl.ResourceAttributesNestedImpl();
  }
  public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
    return new SubjectAccessReviewSpecFluentImpl.ResourceAttributesNestedImpl(item);
  }
  public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes() {
    return withNewResourceAttributesLike(getResourceAttributes());
  }
  public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes() {
    return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): new ResourceAttributesBuilder().build());
  }
  public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
    return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): item);
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public String getUser() {
    return this.user;
  }
  public A withUser(String user) {
    this.user=user; return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubjectAccessReviewSpecFluentImpl that = (SubjectAccessReviewSpecFluentImpl) o;
    if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (nonResourceAttributes != null ? !nonResourceAttributes.equals(that.nonResourceAttributes) :that.nonResourceAttributes != null) return false;
    if (resourceAttributes != null ? !resourceAttributes.equals(that.resourceAttributes) :that.resourceAttributes != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    if (user != null ? !user.equals(that.user) :that.user != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(extra,  group,  nonResourceAttributes,  resourceAttributes,  uid,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (group != null && !group.isEmpty()) { sb.append("group:"); sb.append(group + ","); }
    if (nonResourceAttributes != null) { sb.append("nonResourceAttributes:"); sb.append(nonResourceAttributes + ","); }
    if (resourceAttributes != null) { sb.append("resourceAttributes:"); sb.append(resourceAttributes + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NonResourceAttributesNestedImpl<N> extends NonResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>> implements SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,Nested<N>{
    NonResourceAttributesNestedImpl(NonResourceAttributes item) {
      this.builder = new NonResourceAttributesBuilder(this, item);
    }
    NonResourceAttributesNestedImpl() {
      this.builder = new NonResourceAttributesBuilder(this);
    }
    NonResourceAttributesBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(builder.build());
    }
    public N endNonResourceAttributes() {
      return and();
    }
    
  }
  class ResourceAttributesNestedImpl<N> extends ResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>> implements SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,Nested<N>{
    ResourceAttributesNestedImpl(ResourceAttributes item) {
      this.builder = new ResourceAttributesBuilder(this, item);
    }
    ResourceAttributesNestedImpl() {
      this.builder = new ResourceAttributesBuilder(this);
    }
    ResourceAttributesBuilder builder;
    public N and() {
      return (N) SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(builder.build());
    }
    public N endResourceAttributes() {
      return and();
    }
    
  }
  
}