package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TokenRequestStatusBuilder extends TokenRequestStatusFluent<TokenRequestStatusBuilder> implements VisitableBuilder<TokenRequestStatus,TokenRequestStatusBuilder>{
  public TokenRequestStatusBuilder() {
    this(new TokenRequestStatus());
  }
  
  public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent) {
    this(fluent, new TokenRequestStatus());
  }
  
  public TokenRequestStatusBuilder(TokenRequestStatusFluent<?> fluent,TokenRequestStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TokenRequestStatusBuilder(TokenRequestStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TokenRequestStatusFluent<?> fluent;
  
  public TokenRequestStatus build() {
    TokenRequestStatus buildable = new TokenRequestStatus(fluent.getExpirationTimestamp(),fluent.getToken());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}