package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceAttributesBuilder extends ResourceAttributesFluent<ResourceAttributesBuilder> implements VisitableBuilder<ResourceAttributes,ResourceAttributesBuilder>{
  public ResourceAttributesBuilder() {
    this(new ResourceAttributes());
  }
  
  public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent) {
    this(fluent, new ResourceAttributes());
  }
  
  public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent,ResourceAttributes instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceAttributesBuilder(ResourceAttributes instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceAttributesFluent<?> fluent;
  
  public ResourceAttributes build() {
    ResourceAttributes buildable = new ResourceAttributes(fluent.getGroup(),fluent.getName(),fluent.getNamespace(),fluent.getResource(),fluent.getSubresource(),fluent.getVerb(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}