package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WebhookConversionBuilder extends WebhookConversionFluent<WebhookConversionBuilder> implements VisitableBuilder<WebhookConversion,WebhookConversionBuilder>{
  public WebhookConversionBuilder() {
    this(new WebhookConversion());
  }
  
  public WebhookConversionBuilder(WebhookConversionFluent<?> fluent) {
    this(fluent, new WebhookConversion());
  }
  
  public WebhookConversionBuilder(WebhookConversionFluent<?> fluent,WebhookConversion instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WebhookConversionBuilder(WebhookConversion instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WebhookConversionFluent<?> fluent;
  
  public WebhookConversion build() {
    WebhookConversion buildable = new WebhookConversion(fluent.buildClientConfig(),fluent.getConversionReviewVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}