package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomResourceDefinitionVersionFluent<A extends CustomResourceDefinitionVersionFluent<A>> extends BaseFluent<A>{
  public CustomResourceDefinitionVersionFluent() {
  }
  
  public CustomResourceDefinitionVersionFluent(CustomResourceDefinitionVersion instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CustomResourceColumnDefinitionBuilder> additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();
  private Boolean deprecated;
  private String deprecationWarning;
  private String name;
  private CustomResourceValidationBuilder schema;
  private ArrayList<SelectableFieldBuilder> selectableFields = new ArrayList<SelectableFieldBuilder>();
  private Boolean served;
  private Boolean storage;
  private CustomResourceSubresourcesBuilder subresources;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomResourceDefinitionVersion instance) {
    instance = (instance != null ? instance : new CustomResourceDefinitionVersion());
    if (instance != null) {
          this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
          this.withDeprecated(instance.getDeprecated());
          this.withDeprecationWarning(instance.getDeprecationWarning());
          this.withName(instance.getName());
          this.withSchema(instance.getSchema());
          this.withSelectableFields(instance.getSelectableFields());
          this.withServed(instance.getServed());
          this.withStorage(instance.getStorage());
          this.withSubresources(instance.getSubresources());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalPrinterColumns(int index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= additionalPrinterColumns.size()) { _visitables.get("additionalPrinterColumns").add(builder); additionalPrinterColumns.add(builder); } else { _visitables.get("additionalPrinterColumns").add(index, builder); additionalPrinterColumns.add(index, builder);}
    return (A)this;
  }
  
  public A setToAdditionalPrinterColumns(int index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= additionalPrinterColumns.size()) { _visitables.get("additionalPrinterColumns").add(builder); additionalPrinterColumns.add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder); additionalPrinterColumns.set(index, builder);}
    return (A)this;
  }
  
  public A addToAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... items) {
    if (this.additionalPrinterColumns == null) return (A)this;
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder); this.additionalPrinterColumns.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    if (this.additionalPrinterColumns == null) return (A)this;
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder); this.additionalPrinterColumns.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalPrinterColumns(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    if (additionalPrinterColumns == null) return (A) this;
    final Iterator<CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
    final List visitables = _visitables.get("additionalPrinterColumns");
    while (each.hasNext()) {
      CustomResourceColumnDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
    return this.additionalPrinterColumns != null ? build(additionalPrinterColumns) : null;
  }
  
  public CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
    return this.additionalPrinterColumns.get(index).build();
  }
  
  public CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(0).build();
  }
  
  public CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
  }
  
  public CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
      for (CustomResourceColumnDefinitionBuilder item : additionalPrinterColumns) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
      for (CustomResourceColumnDefinitionBuilder item : additionalPrinterColumns) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalPrinterColumns(List<CustomResourceColumnDefinition> additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) {
      this._visitables.get("additionalPrinterColumns").clear();
    }
    if (additionalPrinterColumns != null) {
        this.additionalPrinterColumns = new ArrayList();
        for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
          this.addToAdditionalPrinterColumns(item);
        }
    } else {
      this.additionalPrinterColumns = null;
    }
    return (A) this;
  }
  
  public A withAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceColumnDefinition... additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) {
        this.additionalPrinterColumns.clear();
        _visitables.remove("additionalPrinterColumns");
    }
    if (additionalPrinterColumns != null) {
      for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
        this.addToAdditionalPrinterColumns(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalPrinterColumns() {
    return this.additionalPrinterColumns != null && !this.additionalPrinterColumns.isEmpty();
  }
  
  public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
    return new AdditionalPrinterColumnsNested(-1, null);
  }
  
  public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(CustomResourceColumnDefinition item) {
    return new AdditionalPrinterColumnsNested(-1, item);
  }
  
  public AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index,CustomResourceColumnDefinition item) {
    return new AdditionalPrinterColumnsNested(index, item);
  }
  
  public AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
    if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  public AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
    if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
  }
  
  public AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
    int index = additionalPrinterColumns.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  public AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalPrinterColumns.size();i++) { 
    if (predicate.test(additionalPrinterColumns.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  public Boolean getDeprecated() {
    return this.deprecated;
  }
  
  public A withDeprecated(Boolean deprecated) {
    this.deprecated = deprecated;
    return (A) this;
  }
  
  public boolean hasDeprecated() {
    return this.deprecated != null;
  }
  
  public String getDeprecationWarning() {
    return this.deprecationWarning;
  }
  
  public A withDeprecationWarning(String deprecationWarning) {
    this.deprecationWarning = deprecationWarning;
    return (A) this;
  }
  
  public boolean hasDeprecationWarning() {
    return this.deprecationWarning != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public CustomResourceValidation buildSchema() {
    return this.schema != null ? this.schema.build() : null;
  }
  
  public A withSchema(CustomResourceValidation schema) {
    this._visitables.remove("schema");
    if (schema != null) {
        this.schema = new CustomResourceValidationBuilder(schema);
        this._visitables.get("schema").add(this.schema);
    } else {
        this.schema = null;
        this._visitables.get("schema").remove(this.schema);
    }
    return (A) this;
  }
  
  public boolean hasSchema() {
    return this.schema != null;
  }
  
  public SchemaNested<A> withNewSchema() {
    return new SchemaNested(null);
  }
  
  public SchemaNested<A> withNewSchemaLike(CustomResourceValidation item) {
    return new SchemaNested(item);
  }
  
  public SchemaNested<A> editSchema() {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(null));
  }
  
  public SchemaNested<A> editOrNewSchema() {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(new CustomResourceValidationBuilder().build()));
  }
  
  public SchemaNested<A> editOrNewSchemaLike(CustomResourceValidation item) {
    return withNewSchemaLike(java.util.Optional.ofNullable(buildSchema()).orElse(item));
  }
  
  public A addToSelectableFields(int index,SelectableField item) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
    if (index < 0 || index >= selectableFields.size()) { _visitables.get("selectableFields").add(builder); selectableFields.add(builder); } else { _visitables.get("selectableFields").add(index, builder); selectableFields.add(index, builder);}
    return (A)this;
  }
  
  public A setToSelectableFields(int index,SelectableField item) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
    if (index < 0 || index >= selectableFields.size()) { _visitables.get("selectableFields").add(builder); selectableFields.add(builder); } else { _visitables.get("selectableFields").set(index, builder); selectableFields.set(index, builder);}
    return (A)this;
  }
  
  public A addToSelectableFields(io.fabric8.kubernetes.api.model.apiextensions.v1.SelectableField... items) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").add(builder);this.selectableFields.add(builder);} return (A)this;
  }
  
  public A addAllToSelectableFields(Collection<SelectableField> items) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").add(builder);this.selectableFields.add(builder);} return (A)this;
  }
  
  public A removeFromSelectableFields(io.fabric8.kubernetes.api.model.apiextensions.v1.SelectableField... items) {
    if (this.selectableFields == null) return (A)this;
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").remove(builder); this.selectableFields.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSelectableFields(Collection<SelectableField> items) {
    if (this.selectableFields == null) return (A)this;
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").remove(builder); this.selectableFields.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSelectableFields(Predicate<SelectableFieldBuilder> predicate) {
    if (selectableFields == null) return (A) this;
    final Iterator<SelectableFieldBuilder> each = selectableFields.iterator();
    final List visitables = _visitables.get("selectableFields");
    while (each.hasNext()) {
      SelectableFieldBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SelectableField> buildSelectableFields() {
    return this.selectableFields != null ? build(selectableFields) : null;
  }
  
  public SelectableField buildSelectableField(int index) {
    return this.selectableFields.get(index).build();
  }
  
  public SelectableField buildFirstSelectableField() {
    return this.selectableFields.get(0).build();
  }
  
  public SelectableField buildLastSelectableField() {
    return this.selectableFields.get(selectableFields.size() - 1).build();
  }
  
  public SelectableField buildMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
      for (SelectableFieldBuilder item : selectableFields) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
      for (SelectableFieldBuilder item : selectableFields) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSelectableFields(List<SelectableField> selectableFields) {
    if (this.selectableFields != null) {
      this._visitables.get("selectableFields").clear();
    }
    if (selectableFields != null) {
        this.selectableFields = new ArrayList();
        for (SelectableField item : selectableFields) {
          this.addToSelectableFields(item);
        }
    } else {
      this.selectableFields = null;
    }
    return (A) this;
  }
  
  public A withSelectableFields(io.fabric8.kubernetes.api.model.apiextensions.v1.SelectableField... selectableFields) {
    if (this.selectableFields != null) {
        this.selectableFields.clear();
        _visitables.remove("selectableFields");
    }
    if (selectableFields != null) {
      for (SelectableField item : selectableFields) {
        this.addToSelectableFields(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSelectableFields() {
    return this.selectableFields != null && !this.selectableFields.isEmpty();
  }
  
  public A addNewSelectableField(String jsonPath) {
    return (A)addToSelectableFields(new SelectableField(jsonPath));
  }
  
  public SelectableFieldsNested<A> addNewSelectableField() {
    return new SelectableFieldsNested(-1, null);
  }
  
  public SelectableFieldsNested<A> addNewSelectableFieldLike(SelectableField item) {
    return new SelectableFieldsNested(-1, item);
  }
  
  public SelectableFieldsNested<A> setNewSelectableFieldLike(int index,SelectableField item) {
    return new SelectableFieldsNested(index, item);
  }
  
  public SelectableFieldsNested<A> editSelectableField(int index) {
    if (selectableFields.size() <= index) throw new RuntimeException("Can't edit selectableFields. Index exceeds size.");
    return setNewSelectableFieldLike(index, buildSelectableField(index));
  }
  
  public SelectableFieldsNested<A> editFirstSelectableField() {
    if (selectableFields.size() == 0) throw new RuntimeException("Can't edit first selectableFields. The list is empty.");
    return setNewSelectableFieldLike(0, buildSelectableField(0));
  }
  
  public SelectableFieldsNested<A> editLastSelectableField() {
    int index = selectableFields.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last selectableFields. The list is empty.");
    return setNewSelectableFieldLike(index, buildSelectableField(index));
  }
  
  public SelectableFieldsNested<A> editMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
    int index = -1;
    for (int i=0;i<selectableFields.size();i++) { 
    if (predicate.test(selectableFields.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching selectableFields. No match found.");
    return setNewSelectableFieldLike(index, buildSelectableField(index));
  }
  
  public Boolean getServed() {
    return this.served;
  }
  
  public A withServed(Boolean served) {
    this.served = served;
    return (A) this;
  }
  
  public boolean hasServed() {
    return this.served != null;
  }
  
  public Boolean getStorage() {
    return this.storage;
  }
  
  public A withStorage(Boolean storage) {
    this.storage = storage;
    return (A) this;
  }
  
  public boolean hasStorage() {
    return this.storage != null;
  }
  
  public CustomResourceSubresources buildSubresources() {
    return this.subresources != null ? this.subresources.build() : null;
  }
  
  public A withSubresources(CustomResourceSubresources subresources) {
    this._visitables.remove("subresources");
    if (subresources != null) {
        this.subresources = new CustomResourceSubresourcesBuilder(subresources);
        this._visitables.get("subresources").add(this.subresources);
    } else {
        this.subresources = null;
        this._visitables.get("subresources").remove(this.subresources);
    }
    return (A) this;
  }
  
  public boolean hasSubresources() {
    return this.subresources != null;
  }
  
  public SubresourcesNested<A> withNewSubresources() {
    return new SubresourcesNested(null);
  }
  
  public SubresourcesNested<A> withNewSubresourcesLike(CustomResourceSubresources item) {
    return new SubresourcesNested(item);
  }
  
  public SubresourcesNested<A> editSubresources() {
    return withNewSubresourcesLike(java.util.Optional.ofNullable(buildSubresources()).orElse(null));
  }
  
  public SubresourcesNested<A> editOrNewSubresources() {
    return withNewSubresourcesLike(java.util.Optional.ofNullable(buildSubresources()).orElse(new CustomResourceSubresourcesBuilder().build()));
  }
  
  public SubresourcesNested<A> editOrNewSubresourcesLike(CustomResourceSubresources item) {
    return withNewSubresourcesLike(java.util.Optional.ofNullable(buildSubresources()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceDefinitionVersionFluent that = (CustomResourceDefinitionVersionFluent) o;
    if (!java.util.Objects.equals(additionalPrinterColumns, that.additionalPrinterColumns)) return false;
    if (!java.util.Objects.equals(deprecated, that.deprecated)) return false;
    if (!java.util.Objects.equals(deprecationWarning, that.deprecationWarning)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(schema, that.schema)) return false;
    if (!java.util.Objects.equals(selectableFields, that.selectableFields)) return false;
    if (!java.util.Objects.equals(served, that.served)) return false;
    if (!java.util.Objects.equals(storage, that.storage)) return false;
    if (!java.util.Objects.equals(subresources, that.subresources)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalPrinterColumns,  deprecated,  deprecationWarning,  name,  schema,  selectableFields,  served,  storage,  subresources,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty()) { sb.append("additionalPrinterColumns:"); sb.append(additionalPrinterColumns + ","); }
    if (deprecated != null) { sb.append("deprecated:"); sb.append(deprecated + ","); }
    if (deprecationWarning != null) { sb.append("deprecationWarning:"); sb.append(deprecationWarning + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (schema != null) { sb.append("schema:"); sb.append(schema + ","); }
    if (selectableFields != null && !selectableFields.isEmpty()) { sb.append("selectableFields:"); sb.append(selectableFields + ","); }
    if (served != null) { sb.append("served:"); sb.append(served + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (subresources != null) { sb.append("subresources:"); sb.append(subresources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDeprecated() {
    return withDeprecated(true);
  }
  
  public A withServed() {
    return withServed(true);
  }
  
  public A withStorage() {
    return withStorage(true);
  }
  public class AdditionalPrinterColumnsNested<N> extends CustomResourceColumnDefinitionFluent<AdditionalPrinterColumnsNested<N>> implements Nested<N>{
    AdditionalPrinterColumnsNested(int index,CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
    }
    CustomResourceColumnDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionVersionFluent.this.setToAdditionalPrinterColumns(index,builder.build());
    }
    
    public N endAdditionalPrinterColumn() {
      return and();
    }
    
  
  }
  public class SchemaNested<N> extends CustomResourceValidationFluent<SchemaNested<N>> implements Nested<N>{
    SchemaNested(CustomResourceValidation item) {
      this.builder = new CustomResourceValidationBuilder(this, item);
    }
    CustomResourceValidationBuilder builder;
    
    public N and() {
      return (N) CustomResourceDefinitionVersionFluent.this.withSchema(builder.build());
    }
    
    public N endSchema() {
      return and();
    }
    
  
  }
  public class SelectableFieldsNested<N> extends SelectableFieldFluent<SelectableFieldsNested<N>> implements Nested<N>{
    SelectableFieldsNested(int index,SelectableField item) {
      this.index = index;
      this.builder = new SelectableFieldBuilder(this, item);
    }
    SelectableFieldBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionVersionFluent.this.setToSelectableFields(index,builder.build());
    }
    
    public N endSelectableField() {
      return and();
    }
    
  
  }
  public class SubresourcesNested<N> extends CustomResourceSubresourcesFluent<SubresourcesNested<N>> implements Nested<N>{
    SubresourcesNested(CustomResourceSubresources item) {
      this.builder = new CustomResourceSubresourcesBuilder(this, item);
    }
    CustomResourceSubresourcesBuilder builder;
    
    public N and() {
      return (N) CustomResourceDefinitionVersionFluent.this.withSubresources(builder.build());
    }
    
    public N endSubresources() {
      return and();
    }
    
  
  }

}