package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConversionResponseFluent<A extends ConversionResponseFluent<A>> extends BaseFluent<A>{
  public ConversionResponseFluent() {
  }
  
  public ConversionResponseFluent(ConversionResponse instance) {
    this.copyInstance(instance);
  }
  private ArrayList<VisitableBuilder<? extends KubernetesResource,?>> convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();
  private Status result;
  private String uid;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConversionResponse instance) {
    instance = (instance != null ? instance : new ConversionResponse());
    if (instance != null) {
          this.withConvertedObjects(instance.getConvertedObjects());
          this.withResult(instance.getResult());
          this.withUid(instance.getUid());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConvertedObjects(VisitableBuilder<? extends KubernetesResource,?> builder) {
    if (this.convertedObjects == null) {this.convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    _visitables.get("convertedObjects").add(builder);this.convertedObjects.add(builder); return (A)this;
  }
  
  public A addToConvertedObjects(int index,VisitableBuilder<? extends KubernetesResource,?> builder) {
    if (this.convertedObjects == null) {this.convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    if (index < 0 || index >= convertedObjects.size()) { _visitables.get("convertedObjects").add(builder); convertedObjects.add(builder); } else { _visitables.get("convertedObjects").add(index, builder); convertedObjects.add(index, builder);}
    return (A)this;
  }
  
  public A addToConvertedObjects(int index,KubernetesResource item) {
    if (this.convertedObjects == null) {this.convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(item);
    if (index < 0 || index >= convertedObjects.size()) { _visitables.get("convertedObjects").add(builder); convertedObjects.add(builder); } else { _visitables.get("convertedObjects").add(index, builder); convertedObjects.add(index, builder);}
    return (A)this;
  }
  
  public A setToConvertedObjects(int index,KubernetesResource item) {
    if (this.convertedObjects == null) {this.convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(item);
    if (index < 0 || index >= convertedObjects.size()) { _visitables.get("convertedObjects").add(builder); convertedObjects.add(builder); } else { _visitables.get("convertedObjects").set(index, builder); convertedObjects.set(index, builder);}
    return (A)this;
  }
  
  public A addToConvertedObjects(io.fabric8.kubernetes.api.model.KubernetesResource... items) {
    if (this.convertedObjects == null) {this.convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (KubernetesResource item : items) { VisitableBuilder<? extends KubernetesResource,?> builder = builder(item); _visitables.get("convertedObjects").add(builder);this.convertedObjects.add(builder); }
    return (A)this;
  }
  
  public A addAllToConvertedObjects(Collection<KubernetesResource> items) {
    if (this.convertedObjects == null) {this.convertedObjects = new ArrayList<VisitableBuilder<? extends KubernetesResource,?>>();}
    for (KubernetesResource item : items) { VisitableBuilder<? extends KubernetesResource,?> builder = builder(item); _visitables.get("convertedObjects").add(builder);this.convertedObjects.add(builder); }
    return (A)this;
  }
  
  public A removeFromConvertedObjects(VisitableBuilder<? extends KubernetesResource,?> builder) {
    if (this.convertedObjects == null) return (A)this;
    _visitables.get("convertedObjects").remove(builder);this.convertedObjects.remove(builder); return (A)this;
  }
  
  public A removeFromConvertedObjects(io.fabric8.kubernetes.api.model.KubernetesResource... items) {
    if (this.convertedObjects == null) return (A)this;
    for (KubernetesResource item : items) {
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(item); _visitables.get("convertedObjects").remove(builder);this.convertedObjects.remove(builder);
    } return (A)this;
  }
  
  public A removeAllFromConvertedObjects(Collection<KubernetesResource> items) {
    if (this.convertedObjects == null) return (A)this;
    for (KubernetesResource item : items) {
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(item); _visitables.get("convertedObjects").remove(builder);this.convertedObjects.remove(builder);
    } return (A)this;
  }
  
  public A removeMatchingFromConvertedObjects(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
    if (convertedObjects == null) return (A) this;
    final Iterator<VisitableBuilder<? extends KubernetesResource,?>> each = convertedObjects.iterator();
    final List visitables = _visitables.get("convertedObjects");
    while (each.hasNext()) {
      VisitableBuilder<? extends KubernetesResource,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KubernetesResource> buildConvertedObjects() {
    return build(convertedObjects);
  }
  
  public KubernetesResource buildConvertedObject(int index) {
    return this.convertedObjects.get(index).build();
  }
  
  public KubernetesResource buildFirstConvertedObject() {
    return this.convertedObjects.get(0).build();
  }
  
  public KubernetesResource buildLastConvertedObject() {
    return this.convertedObjects.get(convertedObjects.size() - 1).build();
  }
  
  public KubernetesResource buildMatchingConvertedObject(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
      for (VisitableBuilder<? extends KubernetesResource,?> item : convertedObjects) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConvertedObject(Predicate<VisitableBuilder<? extends KubernetesResource,?>> predicate) {
      for (VisitableBuilder<? extends KubernetesResource,?> item : convertedObjects) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConvertedObjects(List<KubernetesResource> convertedObjects) {
    if (convertedObjects != null) {
        this.convertedObjects = new ArrayList();
        for (KubernetesResource item : convertedObjects) {
          this.addToConvertedObjects(item);
        }
    } else {
      this.convertedObjects = null;
    }
    return (A) this;
  }
  
  public A withConvertedObjects(io.fabric8.kubernetes.api.model.KubernetesResource... convertedObjects) {
    if (this.convertedObjects != null) {
        this.convertedObjects.clear();
        _visitables.remove("convertedObjects");
    }
    if (convertedObjects != null) {
      for (KubernetesResource item : convertedObjects) {
        this.addToConvertedObjects(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConvertedObjects() {
    return this.convertedObjects != null && !this.convertedObjects.isEmpty();
  }
  
  public V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested<A> addNewV1beta1JSONSchemaPropsOrArrayConvertedObject() {
    return new V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested(-1, null);
  }
  
  public V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested<A> addNewJSONSchemaPropsOrArrayConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
    return new V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested(-1, item);
  }
  
  public V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested<A> setNewJSONSchemaPropsOrArrayConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
    return new V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested(index, item);
  }
  
  public LabelSelectorConvertedObjectsNested<A> addNewLabelSelectorConvertedObject() {
    return new LabelSelectorConvertedObjectsNested(-1, null);
  }
  
  public LabelSelectorConvertedObjectsNested<A> addNewLabelSelectorConvertedObjectLike(LabelSelector item) {
    return new LabelSelectorConvertedObjectsNested(-1, item);
  }
  
  public LabelSelectorConvertedObjectsNested<A> setNewLabelSelectorConvertedObjectLike(int index,LabelSelector item) {
    return new LabelSelectorConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionStatusConvertedObjectsNested<A> addNewCustomResourceDefinitionStatusConvertedObject() {
    return new CustomResourceDefinitionStatusConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionStatusConvertedObjectsNested<A> addNewCustomResourceDefinitionStatusConvertedObjectLike(CustomResourceDefinitionStatus item) {
    return new CustomResourceDefinitionStatusConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceDefinitionStatusConvertedObjectsNested<A> setNewCustomResourceDefinitionStatusConvertedObjectLike(int index,CustomResourceDefinitionStatus item) {
    return new CustomResourceDefinitionStatusConvertedObjectsNested(index, item);
  }
  
  public ServiceReferenceConvertedObjectsNested<A> addNewServiceReferenceConvertedObject() {
    return new ServiceReferenceConvertedObjectsNested(-1, null);
  }
  
  public ServiceReferenceConvertedObjectsNested<A> addNewServiceReferenceConvertedObjectLike(ServiceReference item) {
    return new ServiceReferenceConvertedObjectsNested(-1, item);
  }
  
  public A addNewServiceReferenceConvertedObject(String name,String namespace,String path,Integer port) {
    return (A)addToConvertedObjects(new ServiceReference(name, namespace, path, port));
  }
  
  public ServiceReferenceConvertedObjectsNested<A> setNewServiceReferenceConvertedObjectLike(int index,ServiceReference item) {
    return new ServiceReferenceConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionStatusConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionStatusConvertedObject() {
    return new V1beta1CustomResourceDefinitionStatusConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionStatusConvertedObjectsNested<A> addNewCustomResourceDefinitionStatusConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
    return new V1beta1CustomResourceDefinitionStatusConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceDefinitionStatusConvertedObjectsNested<A> setNewCustomResourceDefinitionStatusConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
    return new V1beta1CustomResourceDefinitionStatusConvertedObjectsNested(index, item);
  }
  
  public JSONSchemaPropsOrBoolConvertedObjectsNested<A> addNewJSONSchemaPropsOrBoolConvertedObject() {
    return new JSONSchemaPropsOrBoolConvertedObjectsNested(-1, null);
  }
  
  public JSONSchemaPropsOrBoolConvertedObjectsNested<A> addNewJSONSchemaPropsOrBoolConvertedObjectLike(JSONSchemaPropsOrBool item) {
    return new JSONSchemaPropsOrBoolConvertedObjectsNested(-1, item);
  }
  
  public JSONSchemaPropsOrBoolConvertedObjectsNested<A> setNewJSONSchemaPropsOrBoolConvertedObjectLike(int index,JSONSchemaPropsOrBool item) {
    return new JSONSchemaPropsOrBoolConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionSpecConvertedObjectsNested<A> addNewCustomResourceDefinitionSpecConvertedObject() {
    return new CustomResourceDefinitionSpecConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionSpecConvertedObjectsNested<A> addNewCustomResourceDefinitionSpecConvertedObjectLike(CustomResourceDefinitionSpec item) {
    return new CustomResourceDefinitionSpecConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceDefinitionSpecConvertedObjectsNested<A> setNewCustomResourceDefinitionSpecConvertedObjectLike(int index,CustomResourceDefinitionSpec item) {
    return new CustomResourceDefinitionSpecConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceSubresourceStatusConvertedObjectsNested<A> addNewV1beta1CustomResourceSubresourceStatusConvertedObject() {
    return new V1beta1CustomResourceSubresourceStatusConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceSubresourceStatusConvertedObjectsNested<A> addNewCustomResourceSubresourceStatusConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
    return new V1beta1CustomResourceSubresourceStatusConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceSubresourceStatusConvertedObjectsNested<A> setNewCustomResourceSubresourceStatusConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
    return new V1beta1CustomResourceSubresourceStatusConvertedObjectsNested(index, item);
  }
  
  public PodTemplateSpecConvertedObjectsNested<A> addNewPodTemplateSpecConvertedObject() {
    return new PodTemplateSpecConvertedObjectsNested(-1, null);
  }
  
  public PodTemplateSpecConvertedObjectsNested<A> addNewPodTemplateSpecConvertedObjectLike(PodTemplateSpec item) {
    return new PodTemplateSpecConvertedObjectsNested(-1, item);
  }
  
  public PodTemplateSpecConvertedObjectsNested<A> setNewPodTemplateSpecConvertedObjectLike(int index,PodTemplateSpec item) {
    return new PodTemplateSpecConvertedObjectsNested(index, item);
  }
  
  public CustomResourceSubresourceScaleConvertedObjectsNested<A> addNewCustomResourceSubresourceScaleConvertedObject() {
    return new CustomResourceSubresourceScaleConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceSubresourceScaleConvertedObjectsNested<A> addNewCustomResourceSubresourceScaleConvertedObjectLike(CustomResourceSubresourceScale item) {
    return new CustomResourceSubresourceScaleConvertedObjectsNested(-1, item);
  }
  
  public A addNewCustomResourceSubresourceScaleConvertedObject(String labelSelectorPath,String specReplicasPath,String statusReplicasPath) {
    return (A)addToConvertedObjects(new CustomResourceSubresourceScale(labelSelectorPath, specReplicasPath, statusReplicasPath));
  }
  
  public CustomResourceSubresourceScaleConvertedObjectsNested<A> setNewCustomResourceSubresourceScaleConvertedObjectLike(int index,CustomResourceSubresourceScale item) {
    return new CustomResourceSubresourceScaleConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionNamesConvertedObjectsNested<A> addNewCustomResourceDefinitionNamesConvertedObject() {
    return new CustomResourceDefinitionNamesConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionNamesConvertedObjectsNested<A> addNewCustomResourceDefinitionNamesConvertedObjectLike(CustomResourceDefinitionNames item) {
    return new CustomResourceDefinitionNamesConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceDefinitionNamesConvertedObjectsNested<A> setNewCustomResourceDefinitionNamesConvertedObjectLike(int index,CustomResourceDefinitionNames item) {
    return new CustomResourceDefinitionNamesConvertedObjectsNested(index, item);
  }
  
  public V1beta1ExternalDocumentationConvertedObjectsNested<A> addNewV1beta1ExternalDocumentationConvertedObject() {
    return new V1beta1ExternalDocumentationConvertedObjectsNested(-1, null);
  }
  
  public V1beta1ExternalDocumentationConvertedObjectsNested<A> addNewExternalDocumentationConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
    return new V1beta1ExternalDocumentationConvertedObjectsNested(-1, item);
  }
  
  public A addNewV1beta1ExternalDocumentationConvertedObject(String description,String url) {
    return (A)addToConvertedObjects(new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation(description, url));
  }
  
  public V1beta1ExternalDocumentationConvertedObjectsNested<A> setNewExternalDocumentationConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
    return new V1beta1ExternalDocumentationConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceSubresourceScaleConvertedObjectsNested<A> addNewV1beta1CustomResourceSubresourceScaleConvertedObject() {
    return new V1beta1CustomResourceSubresourceScaleConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceSubresourceScaleConvertedObjectsNested<A> addNewCustomResourceSubresourceScaleConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
    return new V1beta1CustomResourceSubresourceScaleConvertedObjectsNested(-1, item);
  }
  
  public A addNewV1beta1CustomResourceSubresourceScaleConvertedObject(String labelSelectorPath,String specReplicasPath,String statusReplicasPath) {
    return (A)addToConvertedObjects(new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale(labelSelectorPath, specReplicasPath, statusReplicasPath));
  }
  
  public V1beta1CustomResourceSubresourceScaleConvertedObjectsNested<A> setNewCustomResourceSubresourceScaleConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
    return new V1beta1CustomResourceSubresourceScaleConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionConditionConvertedObjectsNested<A> addNewCustomResourceDefinitionConditionConvertedObject() {
    return new CustomResourceDefinitionConditionConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionConditionConvertedObjectsNested<A> addNewCustomResourceDefinitionConditionConvertedObjectLike(CustomResourceDefinitionCondition item) {
    return new CustomResourceDefinitionConditionConvertedObjectsNested(-1, item);
  }
  
  public A addNewCustomResourceDefinitionConditionConvertedObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConvertedObjects(new CustomResourceDefinitionCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public CustomResourceDefinitionConditionConvertedObjectsNested<A> setNewCustomResourceDefinitionConditionConvertedObjectLike(int index,CustomResourceDefinitionCondition item) {
    return new CustomResourceDefinitionConditionConvertedObjectsNested(index, item);
  }
  
  public CustomResourceSubresourceStatusConvertedObjectsNested<A> addNewCustomResourceSubresourceStatusConvertedObject() {
    return new CustomResourceSubresourceStatusConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceSubresourceStatusConvertedObjectsNested<A> addNewCustomResourceSubresourceStatusConvertedObjectLike(CustomResourceSubresourceStatus item) {
    return new CustomResourceSubresourceStatusConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceSubresourceStatusConvertedObjectsNested<A> setNewCustomResourceSubresourceStatusConvertedObjectLike(int index,CustomResourceSubresourceStatus item) {
    return new CustomResourceSubresourceStatusConvertedObjectsNested(index, item);
  }
  
  public ResourceRequirementsConvertedObjectsNested<A> addNewResourceRequirementsConvertedObject() {
    return new ResourceRequirementsConvertedObjectsNested(-1, null);
  }
  
  public ResourceRequirementsConvertedObjectsNested<A> addNewResourceRequirementsConvertedObjectLike(ResourceRequirements item) {
    return new ResourceRequirementsConvertedObjectsNested(-1, item);
  }
  
  public ResourceRequirementsConvertedObjectsNested<A> setNewResourceRequirementsConvertedObjectLike(int index,ResourceRequirements item) {
    return new ResourceRequirementsConvertedObjectsNested(index, item);
  }
  
  public CustomResourceValidationConvertedObjectsNested<A> addNewCustomResourceValidationConvertedObject() {
    return new CustomResourceValidationConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceValidationConvertedObjectsNested<A> addNewCustomResourceValidationConvertedObjectLike(CustomResourceValidation item) {
    return new CustomResourceValidationConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceValidationConvertedObjectsNested<A> setNewCustomResourceValidationConvertedObjectLike(int index,CustomResourceValidation item) {
    return new CustomResourceValidationConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionVersionConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionVersionConvertedObject() {
    return new V1beta1CustomResourceDefinitionVersionConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionVersionConvertedObjectsNested<A> addNewCustomResourceDefinitionVersionConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
    return new V1beta1CustomResourceDefinitionVersionConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceDefinitionVersionConvertedObjectsNested<A> setNewCustomResourceDefinitionVersionConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
    return new V1beta1CustomResourceDefinitionVersionConvertedObjectsNested(index, item);
  }
  
  public V1beta1JSONSchemaPropsConvertedObjectsNested<A> addNewV1beta1JSONSchemaPropsConvertedObject() {
    return new V1beta1JSONSchemaPropsConvertedObjectsNested(-1, null);
  }
  
  public V1beta1JSONSchemaPropsConvertedObjectsNested<A> addNewJSONSchemaPropsConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
    return new V1beta1JSONSchemaPropsConvertedObjectsNested(-1, item);
  }
  
  public V1beta1JSONSchemaPropsConvertedObjectsNested<A> setNewJSONSchemaPropsConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
    return new V1beta1JSONSchemaPropsConvertedObjectsNested(index, item);
  }
  
  public ConversionResponseConvertedObjectsNested<A> addNewConversionResponseConvertedObject() {
    return new ConversionResponseConvertedObjectsNested(-1, null);
  }
  
  public ConversionResponseConvertedObjectsNested<A> addNewConversionResponseConvertedObjectLike(ConversionResponse item) {
    return new ConversionResponseConvertedObjectsNested(-1, item);
  }
  
  public ConversionResponseConvertedObjectsNested<A> setNewConversionResponseConvertedObjectLike(int index,ConversionResponse item) {
    return new ConversionResponseConvertedObjectsNested(index, item);
  }
  
  public V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested<A> addNewV1beta1JSONSchemaPropsOrBoolConvertedObject() {
    return new V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested(-1, null);
  }
  
  public V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested<A> addNewJSONSchemaPropsOrBoolConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
    return new V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested(-1, item);
  }
  
  public V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested<A> setNewJSONSchemaPropsOrBoolConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
    return new V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested(index, item);
  }
  
  public RawExtensionConvertedObjectsNested<A> addNewRawExtensionConvertedObject() {
    return new RawExtensionConvertedObjectsNested(-1, null);
  }
  
  public RawExtensionConvertedObjectsNested<A> addNewRawExtensionConvertedObjectLike(RawExtension item) {
    return new RawExtensionConvertedObjectsNested(-1, item);
  }
  
  public A addNewRawExtensionConvertedObject(Object value) {
    return (A)addToConvertedObjects(new RawExtension(value));
  }
  
  public RawExtensionConvertedObjectsNested<A> setNewRawExtensionConvertedObjectLike(int index,RawExtension item) {
    return new RawExtensionConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionNamesConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionNamesConvertedObject() {
    return new V1beta1CustomResourceDefinitionNamesConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionNamesConvertedObjectsNested<A> addNewCustomResourceDefinitionNamesConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
    return new V1beta1CustomResourceDefinitionNamesConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceDefinitionNamesConvertedObjectsNested<A> setNewCustomResourceDefinitionNamesConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
    return new V1beta1CustomResourceDefinitionNamesConvertedObjectsNested(index, item);
  }
  
  public V1beta1ValidationRuleConvertedObjectsNested<A> addNewV1beta1ValidationRuleConvertedObject() {
    return new V1beta1ValidationRuleConvertedObjectsNested(-1, null);
  }
  
  public V1beta1ValidationRuleConvertedObjectsNested<A> addNewValidationRuleConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
    return new V1beta1ValidationRuleConvertedObjectsNested(-1, item);
  }
  
  public A addNewV1beta1ValidationRuleConvertedObject(String fieldPath,String message,String messageExpression,String reason,String rule) {
    return (A)addToConvertedObjects(new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule(fieldPath, message, messageExpression, reason, rule));
  }
  
  public V1beta1ValidationRuleConvertedObjectsNested<A> setNewValidationRuleConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
    return new V1beta1ValidationRuleConvertedObjectsNested(index, item);
  }
  
  public JSONSchemaPropsOrStringArrayConvertedObjectsNested<A> addNewJSONSchemaPropsOrStringArrayConvertedObject() {
    return new JSONSchemaPropsOrStringArrayConvertedObjectsNested(-1, null);
  }
  
  public JSONSchemaPropsOrStringArrayConvertedObjectsNested<A> addNewJSONSchemaPropsOrStringArrayConvertedObjectLike(JSONSchemaPropsOrStringArray item) {
    return new JSONSchemaPropsOrStringArrayConvertedObjectsNested(-1, item);
  }
  
  public JSONSchemaPropsOrStringArrayConvertedObjectsNested<A> setNewJSONSchemaPropsOrStringArrayConvertedObjectLike(int index,JSONSchemaPropsOrStringArray item) {
    return new JSONSchemaPropsOrStringArrayConvertedObjectsNested(index, item);
  }
  
  public ObjectMetaConvertedObjectsNested<A> addNewObjectMetaConvertedObject() {
    return new ObjectMetaConvertedObjectsNested(-1, null);
  }
  
  public ObjectMetaConvertedObjectsNested<A> addNewObjectMetaConvertedObjectLike(ObjectMeta item) {
    return new ObjectMetaConvertedObjectsNested(-1, item);
  }
  
  public ObjectMetaConvertedObjectsNested<A> setNewObjectMetaConvertedObjectLike(int index,ObjectMeta item) {
    return new ObjectMetaConvertedObjectsNested(index, item);
  }
  
  public CustomResourceSubresourcesConvertedObjectsNested<A> addNewCustomResourceSubresourcesConvertedObject() {
    return new CustomResourceSubresourcesConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceSubresourcesConvertedObjectsNested<A> addNewCustomResourceSubresourcesConvertedObjectLike(CustomResourceSubresources item) {
    return new CustomResourceSubresourcesConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceSubresourcesConvertedObjectsNested<A> setNewCustomResourceSubresourcesConvertedObjectLike(int index,CustomResourceSubresources item) {
    return new CustomResourceSubresourcesConvertedObjectsNested(index, item);
  }
  
  public PersistentVolumeClaimConvertedObjectsNested<A> addNewPersistentVolumeClaimConvertedObject() {
    return new PersistentVolumeClaimConvertedObjectsNested(-1, null);
  }
  
  public PersistentVolumeClaimConvertedObjectsNested<A> addNewPersistentVolumeClaimConvertedObjectLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimConvertedObjectsNested(-1, item);
  }
  
  public PersistentVolumeClaimConvertedObjectsNested<A> setNewPersistentVolumeClaimConvertedObjectLike(int index,PersistentVolumeClaim item) {
    return new PersistentVolumeClaimConvertedObjectsNested(index, item);
  }
  
  public ConversionRequestConvertedObjectsNested<A> addNewConversionRequestConvertedObject() {
    return new ConversionRequestConvertedObjectsNested(-1, null);
  }
  
  public ConversionRequestConvertedObjectsNested<A> addNewConversionRequestConvertedObjectLike(ConversionRequest item) {
    return new ConversionRequestConvertedObjectsNested(-1, item);
  }
  
  public ConversionRequestConvertedObjectsNested<A> setNewConversionRequestConvertedObjectLike(int index,ConversionRequest item) {
    return new ConversionRequestConvertedObjectsNested(index, item);
  }
  
  public JSONSchemaPropsConvertedObjectsNested<A> addNewJSONSchemaPropsConvertedObject() {
    return new JSONSchemaPropsConvertedObjectsNested(-1, null);
  }
  
  public JSONSchemaPropsConvertedObjectsNested<A> addNewJSONSchemaPropsConvertedObjectLike(JSONSchemaProps item) {
    return new JSONSchemaPropsConvertedObjectsNested(-1, item);
  }
  
  public JSONSchemaPropsConvertedObjectsNested<A> setNewJSONSchemaPropsConvertedObjectLike(int index,JSONSchemaProps item) {
    return new JSONSchemaPropsConvertedObjectsNested(index, item);
  }
  
  public V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested<A> addNewV1beta1JSONSchemaPropsOrStringArrayConvertedObject() {
    return new V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested(-1, null);
  }
  
  public V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested<A> addNewJSONSchemaPropsOrStringArrayConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
    return new V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested(-1, item);
  }
  
  public V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested<A> setNewJSONSchemaPropsOrStringArrayConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
    return new V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested(index, item);
  }
  
  public WebhookClientConfigConvertedObjectsNested<A> addNewWebhookClientConfigConvertedObject() {
    return new WebhookClientConfigConvertedObjectsNested(-1, null);
  }
  
  public WebhookClientConfigConvertedObjectsNested<A> addNewWebhookClientConfigConvertedObjectLike(WebhookClientConfig item) {
    return new WebhookClientConfigConvertedObjectsNested(-1, item);
  }
  
  public WebhookClientConfigConvertedObjectsNested<A> setNewWebhookClientConfigConvertedObjectLike(int index,WebhookClientConfig item) {
    return new WebhookClientConfigConvertedObjectsNested(index, item);
  }
  
  public ContainerConvertedObjectsNested<A> addNewContainerConvertedObject() {
    return new ContainerConvertedObjectsNested(-1, null);
  }
  
  public ContainerConvertedObjectsNested<A> addNewContainerConvertedObjectLike(Container item) {
    return new ContainerConvertedObjectsNested(-1, item);
  }
  
  public ContainerConvertedObjectsNested<A> setNewContainerConvertedObjectLike(int index,Container item) {
    return new ContainerConvertedObjectsNested(index, item);
  }
  
  public GenericKubernetesResourceConvertedObjectsNested<A> addNewGenericKubernetesResourceConvertedObject() {
    return new GenericKubernetesResourceConvertedObjectsNested(-1, null);
  }
  
  public GenericKubernetesResourceConvertedObjectsNested<A> addNewGenericKubernetesResourceConvertedObjectLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceConvertedObjectsNested(-1, item);
  }
  
  public GenericKubernetesResourceConvertedObjectsNested<A> setNewGenericKubernetesResourceConvertedObjectLike(int index,GenericKubernetesResource item) {
    return new GenericKubernetesResourceConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceColumnDefinitionConvertedObjectsNested<A> addNewV1beta1CustomResourceColumnDefinitionConvertedObject() {
    return new V1beta1CustomResourceColumnDefinitionConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceColumnDefinitionConvertedObjectsNested<A> addNewCustomResourceColumnDefinitionConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
    return new V1beta1CustomResourceColumnDefinitionConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceColumnDefinitionConvertedObjectsNested<A> setNewCustomResourceColumnDefinitionConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
    return new V1beta1CustomResourceColumnDefinitionConvertedObjectsNested(index, item);
  }
  
  public V1beta1WebhookClientConfigConvertedObjectsNested<A> addNewV1beta1WebhookClientConfigConvertedObject() {
    return new V1beta1WebhookClientConfigConvertedObjectsNested(-1, null);
  }
  
  public V1beta1WebhookClientConfigConvertedObjectsNested<A> addNewWebhookClientConfigConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
    return new V1beta1WebhookClientConfigConvertedObjectsNested(-1, item);
  }
  
  public V1beta1WebhookClientConfigConvertedObjectsNested<A> setNewWebhookClientConfigConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
    return new V1beta1WebhookClientConfigConvertedObjectsNested(index, item);
  }
  
  public CustomResourceColumnDefinitionConvertedObjectsNested<A> addNewCustomResourceColumnDefinitionConvertedObject() {
    return new CustomResourceColumnDefinitionConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceColumnDefinitionConvertedObjectsNested<A> addNewCustomResourceColumnDefinitionConvertedObjectLike(CustomResourceColumnDefinition item) {
    return new CustomResourceColumnDefinitionConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceColumnDefinitionConvertedObjectsNested<A> setNewCustomResourceColumnDefinitionConvertedObjectLike(int index,CustomResourceColumnDefinition item) {
    return new CustomResourceColumnDefinitionConvertedObjectsNested(index, item);
  }
  
  public WebhookConversionConvertedObjectsNested<A> addNewWebhookConversionConvertedObject() {
    return new WebhookConversionConvertedObjectsNested(-1, null);
  }
  
  public WebhookConversionConvertedObjectsNested<A> addNewWebhookConversionConvertedObjectLike(WebhookConversion item) {
    return new WebhookConversionConvertedObjectsNested(-1, item);
  }
  
  public WebhookConversionConvertedObjectsNested<A> setNewWebhookConversionConvertedObjectLike(int index,WebhookConversion item) {
    return new WebhookConversionConvertedObjectsNested(index, item);
  }
  
  public LocalObjectReferenceConvertedObjectsNested<A> addNewLocalObjectReferenceConvertedObject() {
    return new LocalObjectReferenceConvertedObjectsNested(-1, null);
  }
  
  public LocalObjectReferenceConvertedObjectsNested<A> addNewLocalObjectReferenceConvertedObjectLike(LocalObjectReference item) {
    return new LocalObjectReferenceConvertedObjectsNested(-1, item);
  }
  
  public A addNewLocalObjectReferenceConvertedObject(String name) {
    return (A)addToConvertedObjects(new LocalObjectReference(name));
  }
  
  public LocalObjectReferenceConvertedObjectsNested<A> setNewLocalObjectReferenceConvertedObjectLike(int index,LocalObjectReference item) {
    return new LocalObjectReferenceConvertedObjectsNested(index, item);
  }
  
  public ExternalDocumentationConvertedObjectsNested<A> addNewExternalDocumentationConvertedObject() {
    return new ExternalDocumentationConvertedObjectsNested(-1, null);
  }
  
  public ExternalDocumentationConvertedObjectsNested<A> addNewExternalDocumentationConvertedObjectLike(ExternalDocumentation item) {
    return new ExternalDocumentationConvertedObjectsNested(-1, item);
  }
  
  public A addNewExternalDocumentationConvertedObject(String description,String url) {
    return (A)addToConvertedObjects(new ExternalDocumentation(description, url));
  }
  
  public ExternalDocumentationConvertedObjectsNested<A> setNewExternalDocumentationConvertedObjectLike(int index,ExternalDocumentation item) {
    return new ExternalDocumentationConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceSubresourcesConvertedObjectsNested<A> addNewV1beta1CustomResourceSubresourcesConvertedObject() {
    return new V1beta1CustomResourceSubresourcesConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceSubresourcesConvertedObjectsNested<A> addNewCustomResourceSubresourcesConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
    return new V1beta1CustomResourceSubresourcesConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceSubresourcesConvertedObjectsNested<A> setNewCustomResourceSubresourcesConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
    return new V1beta1CustomResourceSubresourcesConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionVersionConvertedObjectsNested<A> addNewCustomResourceDefinitionVersionConvertedObject() {
    return new CustomResourceDefinitionVersionConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionVersionConvertedObjectsNested<A> addNewCustomResourceDefinitionVersionConvertedObjectLike(CustomResourceDefinitionVersion item) {
    return new CustomResourceDefinitionVersionConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceDefinitionVersionConvertedObjectsNested<A> setNewCustomResourceDefinitionVersionConvertedObjectLike(int index,CustomResourceDefinitionVersion item) {
    return new CustomResourceDefinitionVersionConvertedObjectsNested(index, item);
  }
  
  public CustomResourceConversionConvertedObjectsNested<A> addNewCustomResourceConversionConvertedObject() {
    return new CustomResourceConversionConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceConversionConvertedObjectsNested<A> addNewCustomResourceConversionConvertedObjectLike(CustomResourceConversion item) {
    return new CustomResourceConversionConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceConversionConvertedObjectsNested<A> setNewCustomResourceConversionConvertedObjectLike(int index,CustomResourceConversion item) {
    return new CustomResourceConversionConvertedObjectsNested(index, item);
  }
  
  public ValidationRuleConvertedObjectsNested<A> addNewValidationRuleConvertedObject() {
    return new ValidationRuleConvertedObjectsNested(-1, null);
  }
  
  public ValidationRuleConvertedObjectsNested<A> addNewValidationRuleConvertedObjectLike(ValidationRule item) {
    return new ValidationRuleConvertedObjectsNested(-1, item);
  }
  
  public A addNewValidationRuleConvertedObject(String fieldPath,String message,String messageExpression,String reason,String rule) {
    return (A)addToConvertedObjects(new ValidationRule(fieldPath, message, messageExpression, reason, rule));
  }
  
  public ValidationRuleConvertedObjectsNested<A> setNewValidationRuleConvertedObjectLike(int index,ValidationRule item) {
    return new ValidationRuleConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionConvertedObjectsNested<A> addNewCustomResourceDefinitionConvertedObject() {
    return new CustomResourceDefinitionConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionConvertedObjectsNested<A> addNewCustomResourceDefinitionConvertedObjectLike(CustomResourceDefinition item) {
    return new CustomResourceDefinitionConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceDefinitionConvertedObjectsNested<A> setNewCustomResourceDefinitionConvertedObjectLike(int index,CustomResourceDefinition item) {
    return new CustomResourceDefinitionConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionConditionConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionConditionConvertedObject() {
    return new V1beta1CustomResourceDefinitionConditionConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionConditionConvertedObjectsNested<A> addNewCustomResourceDefinitionConditionConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
    return new V1beta1CustomResourceDefinitionConditionConvertedObjectsNested(-1, item);
  }
  
  public A addNewV1beta1CustomResourceDefinitionConditionConvertedObject(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConvertedObjects(new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public V1beta1CustomResourceDefinitionConditionConvertedObjectsNested<A> setNewCustomResourceDefinitionConditionConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
    return new V1beta1CustomResourceDefinitionConditionConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionListConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionListConvertedObject() {
    return new V1beta1CustomResourceDefinitionListConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionListConvertedObjectsNested<A> addNewCustomResourceDefinitionListConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
    return new V1beta1CustomResourceDefinitionListConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceDefinitionListConvertedObjectsNested<A> setNewCustomResourceDefinitionListConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
    return new V1beta1CustomResourceDefinitionListConvertedObjectsNested(index, item);
  }
  
  public V1beta1ServiceReferenceConvertedObjectsNested<A> addNewV1beta1ServiceReferenceConvertedObject() {
    return new V1beta1ServiceReferenceConvertedObjectsNested(-1, null);
  }
  
  public V1beta1ServiceReferenceConvertedObjectsNested<A> addNewServiceReferenceConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
    return new V1beta1ServiceReferenceConvertedObjectsNested(-1, item);
  }
  
  public A addNewV1beta1ServiceReferenceConvertedObject(String name,String namespace,String path,Integer port) {
    return (A)addToConvertedObjects(new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference(name, namespace, path, port));
  }
  
  public V1beta1ServiceReferenceConvertedObjectsNested<A> setNewServiceReferenceConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
    return new V1beta1ServiceReferenceConvertedObjectsNested(index, item);
  }
  
  public CustomResourceDefinitionListConvertedObjectsNested<A> addNewCustomResourceDefinitionListConvertedObject() {
    return new CustomResourceDefinitionListConvertedObjectsNested(-1, null);
  }
  
  public CustomResourceDefinitionListConvertedObjectsNested<A> addNewCustomResourceDefinitionListConvertedObjectLike(CustomResourceDefinitionList item) {
    return new CustomResourceDefinitionListConvertedObjectsNested(-1, item);
  }
  
  public CustomResourceDefinitionListConvertedObjectsNested<A> setNewCustomResourceDefinitionListConvertedObjectLike(int index,CustomResourceDefinitionList item) {
    return new CustomResourceDefinitionListConvertedObjectsNested(index, item);
  }
  
  public ObjectReferenceConvertedObjectsNested<A> addNewObjectReferenceConvertedObject() {
    return new ObjectReferenceConvertedObjectsNested(-1, null);
  }
  
  public ObjectReferenceConvertedObjectsNested<A> addNewObjectReferenceConvertedObjectLike(ObjectReference item) {
    return new ObjectReferenceConvertedObjectsNested(-1, item);
  }
  
  public ObjectReferenceConvertedObjectsNested<A> setNewObjectReferenceConvertedObjectLike(int index,ObjectReference item) {
    return new ObjectReferenceConvertedObjectsNested(index, item);
  }
  
  public JSONSchemaPropsOrArrayConvertedObjectsNested<A> addNewJSONSchemaPropsOrArrayConvertedObject() {
    return new JSONSchemaPropsOrArrayConvertedObjectsNested(-1, null);
  }
  
  public JSONSchemaPropsOrArrayConvertedObjectsNested<A> addNewJSONSchemaPropsOrArrayConvertedObjectLike(JSONSchemaPropsOrArray item) {
    return new JSONSchemaPropsOrArrayConvertedObjectsNested(-1, item);
  }
  
  public JSONSchemaPropsOrArrayConvertedObjectsNested<A> setNewJSONSchemaPropsOrArrayConvertedObjectLike(int index,JSONSchemaPropsOrArray item) {
    return new JSONSchemaPropsOrArrayConvertedObjectsNested(index, item);
  }
  
  public ConversionReviewConvertedObjectsNested<A> addNewConversionReviewConvertedObject() {
    return new ConversionReviewConvertedObjectsNested(-1, null);
  }
  
  public ConversionReviewConvertedObjectsNested<A> addNewConversionReviewConvertedObjectLike(ConversionReview item) {
    return new ConversionReviewConvertedObjectsNested(-1, item);
  }
  
  public ConversionReviewConvertedObjectsNested<A> setNewConversionReviewConvertedObjectLike(int index,ConversionReview item) {
    return new ConversionReviewConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceValidationConvertedObjectsNested<A> addNewV1beta1CustomResourceValidationConvertedObject() {
    return new V1beta1CustomResourceValidationConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceValidationConvertedObjectsNested<A> addNewCustomResourceValidationConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
    return new V1beta1CustomResourceValidationConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceValidationConvertedObjectsNested<A> setNewCustomResourceValidationConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
    return new V1beta1CustomResourceValidationConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceConversionConvertedObjectsNested<A> addNewV1beta1CustomResourceConversionConvertedObject() {
    return new V1beta1CustomResourceConversionConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceConversionConvertedObjectsNested<A> addNewCustomResourceConversionConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
    return new V1beta1CustomResourceConversionConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceConversionConvertedObjectsNested<A> setNewCustomResourceConversionConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
    return new V1beta1CustomResourceConversionConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionConvertedObject() {
    return new V1beta1CustomResourceDefinitionConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionConvertedObjectsNested<A> addNewCustomResourceDefinitionConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
    return new V1beta1CustomResourceDefinitionConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceDefinitionConvertedObjectsNested<A> setNewCustomResourceDefinitionConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
    return new V1beta1CustomResourceDefinitionConvertedObjectsNested(index, item);
  }
  
  public V1beta1CustomResourceDefinitionSpecConvertedObjectsNested<A> addNewV1beta1CustomResourceDefinitionSpecConvertedObject() {
    return new V1beta1CustomResourceDefinitionSpecConvertedObjectsNested(-1, null);
  }
  
  public V1beta1CustomResourceDefinitionSpecConvertedObjectsNested<A> addNewCustomResourceDefinitionSpecConvertedObjectLike(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
    return new V1beta1CustomResourceDefinitionSpecConvertedObjectsNested(-1, item);
  }
  
  public V1beta1CustomResourceDefinitionSpecConvertedObjectsNested<A> setNewCustomResourceDefinitionSpecConvertedObjectLike(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
    return new V1beta1CustomResourceDefinitionSpecConvertedObjectsNested(index, item);
  }
  
  public Status getResult() {
    return this.result;
  }
  
  public A withResult(Status result) {
    this.result = result;
    return (A) this;
  }
  
  public boolean hasResult() {
    return this.result != null;
  }
  
  public String getUid() {
    return this.uid;
  }
  
  public A withUid(String uid) {
    this.uid = uid;
    return (A) this;
  }
  
  public boolean hasUid() {
    return this.uid != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConversionResponseFluent that = (ConversionResponseFluent) o;
    if (!java.util.Objects.equals(convertedObjects, that.convertedObjects)) return false;
    if (!java.util.Objects.equals(result, that.result)) return false;
    if (!java.util.Objects.equals(uid, that.uid)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(convertedObjects,  result,  uid,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (convertedObjects != null && !convertedObjects.isEmpty()) { sb.append("convertedObjects:"); sb.append(convertedObjects + ","); }
    if (result != null) { sb.append("result:"); sb.append(result + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"JSONSchemaPropsOrArray": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinitionStatus": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionStatusBuilder((CustomResourceDefinitionStatus) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"ServiceReference": return (VisitableBuilder<T, ?>)new ServiceReferenceBuilder((ServiceReference) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinitionStatus": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"JSONSchemaPropsOrBool": return (VisitableBuilder<T, ?>)new JSONSchemaPropsOrBoolBuilder((JSONSchemaPropsOrBool) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinitionSpec": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionSpecBuilder((CustomResourceDefinitionSpec) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceSubresourceStatus": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceSubresourceScale": return (VisitableBuilder<T, ?>)new CustomResourceSubresourceScaleBuilder((CustomResourceSubresourceScale) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinitionNames": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionNamesBuilder((CustomResourceDefinitionNames) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"ExternalDocumentation": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceSubresourceScale": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinitionCondition": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionConditionBuilder((CustomResourceDefinitionCondition) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceSubresourceStatus": return (VisitableBuilder<T, ?>)new CustomResourceSubresourceStatusBuilder((CustomResourceSubresourceStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceValidation": return (VisitableBuilder<T, ?>)new CustomResourceValidationBuilder((CustomResourceValidation) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinitionVersion": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"JSONSchemaProps": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"ConversionResponse": return (VisitableBuilder<T, ?>)new ConversionResponseBuilder((ConversionResponse) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"JSONSchemaPropsOrBool": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinitionNames": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"ValidationRule": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"JSONSchemaPropsOrStringArray": return (VisitableBuilder<T, ?>)new JSONSchemaPropsOrStringArrayBuilder((JSONSchemaPropsOrStringArray) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceSubresources": return (VisitableBuilder<T, ?>)new CustomResourceSubresourcesBuilder((CustomResourceSubresources) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"ConversionRequest": return (VisitableBuilder<T, ?>)new ConversionRequestBuilder((ConversionRequest) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"JSONSchemaProps": return (VisitableBuilder<T, ?>)new JSONSchemaPropsBuilder((JSONSchemaProps) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"JSONSchemaPropsOrStringArray": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"WebhookClientConfig": return (VisitableBuilder<T, ?>)new WebhookClientConfigBuilder((WebhookClientConfig) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceColumnDefinition": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"WebhookClientConfig": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceColumnDefinition": return (VisitableBuilder<T, ?>)new CustomResourceColumnDefinitionBuilder((CustomResourceColumnDefinition) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"WebhookConversion": return (VisitableBuilder<T, ?>)new WebhookConversionBuilder((WebhookConversion) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"ExternalDocumentation": return (VisitableBuilder<T, ?>)new ExternalDocumentationBuilder((ExternalDocumentation) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceSubresources": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinitionVersion": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionVersionBuilder((CustomResourceDefinitionVersion) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceConversion": return (VisitableBuilder<T, ?>)new CustomResourceConversionBuilder((CustomResourceConversion) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"ValidationRule": return (VisitableBuilder<T, ?>)new ValidationRuleBuilder((ValidationRule) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinition": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionBuilder((CustomResourceDefinition) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinitionCondition": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinitionList": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"ServiceReference": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"CustomResourceDefinitionList": return (VisitableBuilder<T, ?>)new CustomResourceDefinitionListBuilder((CustomResourceDefinitionList) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"JSONSchemaPropsOrArray": return (VisitableBuilder<T, ?>)new JSONSchemaPropsOrArrayBuilder((JSONSchemaPropsOrArray) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1."+"ConversionReview": return (VisitableBuilder<T, ?>)new ConversionReviewBuilder((ConversionReview) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceValidation": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceConversion": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinition": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition) item);
    case "io.fabric8.kubernetes.api.model.apiextensions.v1beta1."+"CustomResourceDefinitionSpec": return (VisitableBuilder<T, ?>)new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder((io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayFluent<V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1JSONSchemaPropsOrArrayConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArrayBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1JSONSchemaPropsOrArrayConvertedObject() {
      return and();
    }
    
  
  }
  public class LabelSelectorConvertedObjectsNested<N> extends LabelSelectorFluent<LabelSelectorConvertedObjectsNested<N>> implements Nested<N>{
    LabelSelectorConvertedObjectsNested(int index,LabelSelector item) {
      this.index = index;
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endLabelSelectorConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionStatusConvertedObjectsNested<N> extends CustomResourceDefinitionStatusFluent<CustomResourceDefinitionStatusConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionStatusConvertedObjectsNested(int index,CustomResourceDefinitionStatus item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionStatusBuilder(this, item);
    }
    CustomResourceDefinitionStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionStatusConvertedObject() {
      return and();
    }
    
  
  }
  public class ServiceReferenceConvertedObjectsNested<N> extends ServiceReferenceFluent<ServiceReferenceConvertedObjectsNested<N>> implements Nested<N>{
    ServiceReferenceConvertedObjectsNested(int index,ServiceReference item) {
      this.index = index;
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endServiceReferenceConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionStatusConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusFluent<V1beta1CustomResourceDefinitionStatusConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionStatusConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionStatusConvertedObject() {
      return and();
    }
    
  
  }
  public class JSONSchemaPropsOrBoolConvertedObjectsNested<N> extends JSONSchemaPropsOrBoolFluent<JSONSchemaPropsOrBoolConvertedObjectsNested<N>> implements Nested<N>{
    JSONSchemaPropsOrBoolConvertedObjectsNested(int index,JSONSchemaPropsOrBool item) {
      this.index = index;
      this.builder = new JSONSchemaPropsOrBoolBuilder(this, item);
    }
    JSONSchemaPropsOrBoolBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endJSONSchemaPropsOrBoolConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionSpecConvertedObjectsNested<N> extends CustomResourceDefinitionSpecFluent<CustomResourceDefinitionSpecConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionSpecConvertedObjectsNested(int index,CustomResourceDefinitionSpec item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionSpecBuilder(this, item);
    }
    CustomResourceDefinitionSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionSpecConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceSubresourceStatusConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusFluent<V1beta1CustomResourceSubresourceStatusConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceSubresourceStatusConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatus item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceSubresourceStatusConvertedObject() {
      return and();
    }
    
  
  }
  public class PodTemplateSpecConvertedObjectsNested<N> extends PodTemplateSpecFluent<PodTemplateSpecConvertedObjectsNested<N>> implements Nested<N>{
    PodTemplateSpecConvertedObjectsNested(int index,PodTemplateSpec item) {
      this.index = index;
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endPodTemplateSpecConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceSubresourceScaleConvertedObjectsNested<N> extends CustomResourceSubresourceScaleFluent<CustomResourceSubresourceScaleConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceSubresourceScaleConvertedObjectsNested(int index,CustomResourceSubresourceScale item) {
      this.index = index;
      this.builder = new CustomResourceSubresourceScaleBuilder(this, item);
    }
    CustomResourceSubresourceScaleBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceSubresourceScaleConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionNamesConvertedObjectsNested<N> extends CustomResourceDefinitionNamesFluent<CustomResourceDefinitionNamesConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionNamesConvertedObjectsNested(int index,CustomResourceDefinitionNames item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
    }
    CustomResourceDefinitionNamesBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionNamesConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1ExternalDocumentationConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationFluent<V1beta1ExternalDocumentationConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1ExternalDocumentationConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentation item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ExternalDocumentationBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1ExternalDocumentationConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceSubresourceScaleConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleFluent<V1beta1CustomResourceSubresourceScaleConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceSubresourceScaleConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScale item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourceScaleBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceSubresourceScaleConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionConditionConvertedObjectsNested<N> extends CustomResourceDefinitionConditionFluent<CustomResourceDefinitionConditionConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionConditionConvertedObjectsNested(int index,CustomResourceDefinitionCondition item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionConditionBuilder(this, item);
    }
    CustomResourceDefinitionConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionConditionConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceSubresourceStatusConvertedObjectsNested<N> extends CustomResourceSubresourceStatusFluent<CustomResourceSubresourceStatusConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceSubresourceStatusConvertedObjectsNested(int index,CustomResourceSubresourceStatus item) {
      this.index = index;
      this.builder = new CustomResourceSubresourceStatusBuilder(this, item);
    }
    CustomResourceSubresourceStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceSubresourceStatusConvertedObject() {
      return and();
    }
    
  
  }
  public class ResourceRequirementsConvertedObjectsNested<N> extends ResourceRequirementsFluent<ResourceRequirementsConvertedObjectsNested<N>> implements Nested<N>{
    ResourceRequirementsConvertedObjectsNested(int index,ResourceRequirements item) {
      this.index = index;
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endResourceRequirementsConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceValidationConvertedObjectsNested<N> extends CustomResourceValidationFluent<CustomResourceValidationConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceValidationConvertedObjectsNested(int index,CustomResourceValidation item) {
      this.index = index;
      this.builder = new CustomResourceValidationBuilder(this, item);
    }
    CustomResourceValidationBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceValidationConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionVersionConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionFluent<V1beta1CustomResourceDefinitionVersionConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionVersionConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionVersionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1JSONSchemaPropsConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsFluent<V1beta1JSONSchemaPropsConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1JSONSchemaPropsConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1JSONSchemaPropsConvertedObject() {
      return and();
    }
    
  
  }
  public class ConversionResponseConvertedObjectsNested<N> extends ConversionResponseFluent<ConversionResponseConvertedObjectsNested<N>> implements Nested<N>{
    ConversionResponseConvertedObjectsNested(int index,ConversionResponse item) {
      this.index = index;
      this.builder = new ConversionResponseBuilder(this, item);
    }
    ConversionResponseBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endConversionResponseConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolFluent<V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1JSONSchemaPropsOrBoolConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1JSONSchemaPropsOrBoolConvertedObject() {
      return and();
    }
    
  
  }
  public class RawExtensionConvertedObjectsNested<N> extends RawExtensionFluent<RawExtensionConvertedObjectsNested<N>> implements Nested<N>{
    RawExtensionConvertedObjectsNested(int index,RawExtension item) {
      this.index = index;
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endRawExtensionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionNamesConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesFluent<V1beta1CustomResourceDefinitionNamesConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionNamesConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNamesBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionNamesConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1ValidationRuleConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleFluent<V1beta1ValidationRuleConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1ValidationRuleConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1ValidationRuleConvertedObject() {
      return and();
    }
    
  
  }
  public class JSONSchemaPropsOrStringArrayConvertedObjectsNested<N> extends JSONSchemaPropsOrStringArrayFluent<JSONSchemaPropsOrStringArrayConvertedObjectsNested<N>> implements Nested<N>{
    JSONSchemaPropsOrStringArrayConvertedObjectsNested(int index,JSONSchemaPropsOrStringArray item) {
      this.index = index;
      this.builder = new JSONSchemaPropsOrStringArrayBuilder(this, item);
    }
    JSONSchemaPropsOrStringArrayBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endJSONSchemaPropsOrStringArrayConvertedObject() {
      return and();
    }
    
  
  }
  public class ObjectMetaConvertedObjectsNested<N> extends ObjectMetaFluent<ObjectMetaConvertedObjectsNested<N>> implements Nested<N>{
    ObjectMetaConvertedObjectsNested(int index,ObjectMeta item) {
      this.index = index;
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endObjectMetaConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceSubresourcesConvertedObjectsNested<N> extends CustomResourceSubresourcesFluent<CustomResourceSubresourcesConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceSubresourcesConvertedObjectsNested(int index,CustomResourceSubresources item) {
      this.index = index;
      this.builder = new CustomResourceSubresourcesBuilder(this, item);
    }
    CustomResourceSubresourcesBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceSubresourcesConvertedObject() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimConvertedObjectsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimConvertedObjectsNested<N>> implements Nested<N>{
    PersistentVolumeClaimConvertedObjectsNested(int index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endPersistentVolumeClaimConvertedObject() {
      return and();
    }
    
  
  }
  public class ConversionRequestConvertedObjectsNested<N> extends ConversionRequestFluent<ConversionRequestConvertedObjectsNested<N>> implements Nested<N>{
    ConversionRequestConvertedObjectsNested(int index,ConversionRequest item) {
      this.index = index;
      this.builder = new ConversionRequestBuilder(this, item);
    }
    ConversionRequestBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endConversionRequestConvertedObject() {
      return and();
    }
    
  
  }
  public class JSONSchemaPropsConvertedObjectsNested<N> extends JSONSchemaPropsFluent<JSONSchemaPropsConvertedObjectsNested<N>> implements Nested<N>{
    JSONSchemaPropsConvertedObjectsNested(int index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endJSONSchemaPropsConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayFluent<V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1JSONSchemaPropsOrStringArrayConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArrayBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1JSONSchemaPropsOrStringArrayConvertedObject() {
      return and();
    }
    
  
  }
  public class WebhookClientConfigConvertedObjectsNested<N> extends WebhookClientConfigFluent<WebhookClientConfigConvertedObjectsNested<N>> implements Nested<N>{
    WebhookClientConfigConvertedObjectsNested(int index,WebhookClientConfig item) {
      this.index = index;
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    WebhookClientConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endWebhookClientConfigConvertedObject() {
      return and();
    }
    
  
  }
  public class ContainerConvertedObjectsNested<N> extends ContainerFluent<ContainerConvertedObjectsNested<N>> implements Nested<N>{
    ContainerConvertedObjectsNested(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endContainerConvertedObject() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceConvertedObjectsNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceConvertedObjectsNested<N>> implements Nested<N>{
    GenericKubernetesResourceConvertedObjectsNested(int index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endGenericKubernetesResourceConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceColumnDefinitionConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionFluent<V1beta1CustomResourceColumnDefinitionConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceColumnDefinitionConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceColumnDefinitionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1WebhookClientConfigConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigFluent<V1beta1WebhookClientConfigConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1WebhookClientConfigConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfig item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.WebhookClientConfigBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1WebhookClientConfigConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceColumnDefinitionConvertedObjectsNested<N> extends CustomResourceColumnDefinitionFluent<CustomResourceColumnDefinitionConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceColumnDefinitionConvertedObjectsNested(int index,CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
    }
    CustomResourceColumnDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceColumnDefinitionConvertedObject() {
      return and();
    }
    
  
  }
  public class WebhookConversionConvertedObjectsNested<N> extends WebhookConversionFluent<WebhookConversionConvertedObjectsNested<N>> implements Nested<N>{
    WebhookConversionConvertedObjectsNested(int index,WebhookConversion item) {
      this.index = index;
      this.builder = new WebhookConversionBuilder(this, item);
    }
    WebhookConversionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endWebhookConversionConvertedObject() {
      return and();
    }
    
  
  }
  public class LocalObjectReferenceConvertedObjectsNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceConvertedObjectsNested<N>> implements Nested<N>{
    LocalObjectReferenceConvertedObjectsNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endLocalObjectReferenceConvertedObject() {
      return and();
    }
    
  
  }
  public class ExternalDocumentationConvertedObjectsNested<N> extends ExternalDocumentationFluent<ExternalDocumentationConvertedObjectsNested<N>> implements Nested<N>{
    ExternalDocumentationConvertedObjectsNested(int index,ExternalDocumentation item) {
      this.index = index;
      this.builder = new ExternalDocumentationBuilder(this, item);
    }
    ExternalDocumentationBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endExternalDocumentationConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceSubresourcesConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesFluent<V1beta1CustomResourceSubresourcesConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceSubresourcesConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresourcesBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceSubresourcesConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionVersionConvertedObjectsNested<N> extends CustomResourceDefinitionVersionFluent<CustomResourceDefinitionVersionConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionVersionConvertedObjectsNested(int index,CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
    }
    CustomResourceDefinitionVersionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionVersionConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceConversionConvertedObjectsNested<N> extends CustomResourceConversionFluent<CustomResourceConversionConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceConversionConvertedObjectsNested(int index,CustomResourceConversion item) {
      this.index = index;
      this.builder = new CustomResourceConversionBuilder(this, item);
    }
    CustomResourceConversionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceConversionConvertedObject() {
      return and();
    }
    
  
  }
  public class ValidationRuleConvertedObjectsNested<N> extends ValidationRuleFluent<ValidationRuleConvertedObjectsNested<N>> implements Nested<N>{
    ValidationRuleConvertedObjectsNested(int index,ValidationRule item) {
      this.index = index;
      this.builder = new ValidationRuleBuilder(this, item);
    }
    ValidationRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endValidationRuleConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionConvertedObjectsNested<N> extends CustomResourceDefinitionFluent<CustomResourceDefinitionConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionConvertedObjectsNested(int index,CustomResourceDefinition item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionBuilder(this, item);
    }
    CustomResourceDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionConditionConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionFluent<V1beta1CustomResourceDefinitionConditionConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionConditionConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionConditionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionListConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListFluent<V1beta1CustomResourceDefinitionListConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionListConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionListBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionListConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1ServiceReferenceConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceFluent<V1beta1ServiceReferenceConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1ServiceReferenceConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReference item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ServiceReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1ServiceReferenceConvertedObject() {
      return and();
    }
    
  
  }
  public class CustomResourceDefinitionListConvertedObjectsNested<N> extends CustomResourceDefinitionListFluent<CustomResourceDefinitionListConvertedObjectsNested<N>> implements Nested<N>{
    CustomResourceDefinitionListConvertedObjectsNested(int index,CustomResourceDefinitionList item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionListBuilder(this, item);
    }
    CustomResourceDefinitionListBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endCustomResourceDefinitionListConvertedObject() {
      return and();
    }
    
  
  }
  public class ObjectReferenceConvertedObjectsNested<N> extends ObjectReferenceFluent<ObjectReferenceConvertedObjectsNested<N>> implements Nested<N>{
    ObjectReferenceConvertedObjectsNested(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endObjectReferenceConvertedObject() {
      return and();
    }
    
  
  }
  public class JSONSchemaPropsOrArrayConvertedObjectsNested<N> extends JSONSchemaPropsOrArrayFluent<JSONSchemaPropsOrArrayConvertedObjectsNested<N>> implements Nested<N>{
    JSONSchemaPropsOrArrayConvertedObjectsNested(int index,JSONSchemaPropsOrArray item) {
      this.index = index;
      this.builder = new JSONSchemaPropsOrArrayBuilder(this, item);
    }
    JSONSchemaPropsOrArrayBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endJSONSchemaPropsOrArrayConvertedObject() {
      return and();
    }
    
  
  }
  public class ConversionReviewConvertedObjectsNested<N> extends ConversionReviewFluent<ConversionReviewConvertedObjectsNested<N>> implements Nested<N>{
    ConversionReviewConvertedObjectsNested(int index,ConversionReview item) {
      this.index = index;
      this.builder = new ConversionReviewBuilder(this, item);
    }
    ConversionReviewBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endConversionReviewConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceValidationConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationFluent<V1beta1CustomResourceValidationConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceValidationConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidationBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceValidationConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceConversionConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionFluent<V1beta1CustomResourceConversionConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceConversionConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversion item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceConversionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceConversionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionFluent<V1beta1CustomResourceDefinitionConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionConvertedObject() {
      return and();
    }
    
  
  }
  public class V1beta1CustomResourceDefinitionSpecConvertedObjectsNested<N> extends io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent<V1beta1CustomResourceDefinitionSpecConvertedObjectsNested<N>> implements Nested<N>{
    V1beta1CustomResourceDefinitionSpecConvertedObjectsNested(int index,io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder(this, item);
    }
    io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) ConversionResponseFluent.this.setToConvertedObjects(index,builder.build());
    }
    
    public N endV1beta1CustomResourceDefinitionSpecConvertedObject() {
      return and();
    }
    
  
  }

}