package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>> extends Fluent<A>{
  public Integer getMaxReplicas();
  public A withMaxReplicas(Integer maxReplicas);
  public Boolean hasMaxReplicas();
  public Integer getMinReplicas();
  public A withMinReplicas(Integer minReplicas);
  public Boolean hasMinReplicas();
  
  /**
   * This method has been deprecated, please use method buildScaleTargetRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public CrossVersionObjectReference getScaleTargetRef();
  public CrossVersionObjectReference buildScaleTargetRef();
  public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef);
  public Boolean hasScaleTargetRef();
  public A withNewScaleTargetRef(String apiVersion,String kind,String name);
  public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef();
  public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item);
  public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef();
  public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef();
  public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item);
  public Integer getTargetCPUUtilizationPercentage();
  public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage);
  public Boolean hasTargetCPUUtilizationPercentage();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ScaleTargetRefNested<N> extends Nested<N>,CrossVersionObjectReferenceFluent<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>{
    public N and();
    public N endScaleTargetRef();
    
  }
  
}