package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceMetricSourceBuilder extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder> implements VisitableBuilder<ResourceMetricSource,ResourceMetricSourceBuilder>{
  public ResourceMetricSourceBuilder() {
    this(false);
  }
  public ResourceMetricSourceBuilder(Boolean validationEnabled) {
    this(new ResourceMetricSource(), validationEnabled);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceMetricSource(), validationEnabled);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent,ResourceMetricSource instance) {
    this(fluent, instance, false);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent,ResourceMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
    fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceMetricSourceBuilder(ResourceMetricSource instance) {
    this(instance,false);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
    this.withTargetAverageValue(instance.getTargetAverageValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceMetricSource build() {
    ResourceMetricSource buildable = new ResourceMetricSource(fluent.getName(),fluent.getTargetAverageUtilization(),fluent.getTargetAverageValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}