package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ScaleStatusBuilder extends ScaleStatusFluent<ScaleStatusBuilder> implements VisitableBuilder<ScaleStatus,ScaleStatusBuilder>{
  public ScaleStatusBuilder() {
    this(new ScaleStatus());
  }
  
  public ScaleStatusBuilder(ScaleStatusFluent<?> fluent) {
    this(fluent, new ScaleStatus());
  }
  
  public ScaleStatusBuilder(ScaleStatusFluent<?> fluent,ScaleStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ScaleStatusBuilder(ScaleStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ScaleStatusFluent<?> fluent;
  
  public ScaleStatus build() {
    ScaleStatus buildable = new ScaleStatus(fluent.getReplicas(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}