package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ObjectMetricStatusFluent<A extends ObjectMetricStatusFluent<A>> extends BaseFluent<A>{
  public ObjectMetricStatusFluent() {
  }
  
  public ObjectMetricStatusFluent(ObjectMetricStatus instance) {
    this.copyInstance(instance);
  }
  private Quantity averageValue;
  private Quantity currentValue;
  private String metricName;
  private LabelSelectorBuilder selector;
  private CrossVersionObjectReferenceBuilder target;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ObjectMetricStatus instance) {
    instance = (instance != null ? instance : new ObjectMetricStatus());
    if (instance != null) {
          this.withAverageValue(instance.getAverageValue());
          this.withCurrentValue(instance.getCurrentValue());
          this.withMetricName(instance.getMetricName());
          this.withSelector(instance.getSelector());
          this.withTarget(instance.getTarget());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Quantity getAverageValue() {
    return this.averageValue;
  }
  
  public A withAverageValue(Quantity averageValue) {
    this.averageValue = averageValue;
    return (A) this;
  }
  
  public boolean hasAverageValue() {
    return this.averageValue != null;
  }
  
  public A withNewAverageValue(String amount,String format) {
    return (A)withAverageValue(new Quantity(amount, format));
  }
  
  public A withNewAverageValue(String amount) {
    return (A)withAverageValue(new Quantity(amount));
  }
  
  public Quantity getCurrentValue() {
    return this.currentValue;
  }
  
  public A withCurrentValue(Quantity currentValue) {
    this.currentValue = currentValue;
    return (A) this;
  }
  
  public boolean hasCurrentValue() {
    return this.currentValue != null;
  }
  
  public A withNewCurrentValue(String amount,String format) {
    return (A)withCurrentValue(new Quantity(amount, format));
  }
  
  public A withNewCurrentValue(String amount) {
    return (A)withCurrentValue(new Quantity(amount));
  }
  
  public String getMetricName() {
    return this.metricName;
  }
  
  public A withMetricName(String metricName) {
    this.metricName = metricName;
    return (A) this;
  }
  
  public boolean hasMetricName() {
    return this.metricName != null;
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public CrossVersionObjectReference buildTarget() {
    return this.target != null ? this.target.build() : null;
  }
  
  public A withTarget(CrossVersionObjectReference target) {
    this._visitables.remove("target");
    if (target != null) {
        this.target = new CrossVersionObjectReferenceBuilder(target);
        this._visitables.get("target").add(this.target);
    } else {
        this.target = null;
        this._visitables.get("target").remove(this.target);
    }
    return (A) this;
  }
  
  public boolean hasTarget() {
    return this.target != null;
  }
  
  public A withNewTarget(String apiVersion,String kind,String name) {
    return (A)withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  
  public TargetNested<A> withNewTarget() {
    return new TargetNested(null);
  }
  
  public TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
    return new TargetNested(item);
  }
  
  public TargetNested<A> editTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(null));
  }
  
  public TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(new CrossVersionObjectReferenceBuilder().build()));
  }
  
  public TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ObjectMetricStatusFluent that = (ObjectMetricStatusFluent) o;
    if (!java.util.Objects.equals(averageValue, that.averageValue)) return false;
    if (!java.util.Objects.equals(currentValue, that.currentValue)) return false;
    if (!java.util.Objects.equals(metricName, that.metricName)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(target, that.target)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(averageValue,  currentValue,  metricName,  selector,  target,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (averageValue != null) { sb.append("averageValue:"); sb.append(averageValue + ","); }
    if (currentValue != null) { sb.append("currentValue:"); sb.append(currentValue + ","); }
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ObjectMetricStatusFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class TargetNested<N> extends CrossVersionObjectReferenceFluent<TargetNested<N>> implements Nested<N>{
    TargetNested(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    CrossVersionObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ObjectMetricStatusFluent.this.withTarget(builder.build());
    }
    
    public N endTarget() {
      return and();
    }
    
  
  }

}