package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClientIPConfigBuilder extends io.fabric8.kubernetes.api.model.ClientIPConfigFluentImpl<io.fabric8.kubernetes.api.model.ClientIPConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ClientIPConfig,io.fabric8.kubernetes.api.model.ClientIPConfigBuilder> {

    io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClientIPConfigBuilder() {
        this(true);
    }

    public ClientIPConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new ClientIPConfig(), validationEnabled);
    }

    public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClientIPConfig(), validationEnabled);
    }

    public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ClientIPConfig instance) {
        this(fluent, instance, true);
    }

    public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ClientIPConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfig instance) {
        this(instance,true);
    }

    public ClientIPConfigBuilder(io.fabric8.kubernetes.api.model.ClientIPConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ClientIPConfig build() {
        ClientIPConfig buildable = new ClientIPConfig(fluent.getTimeoutSeconds());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClientIPConfigBuilder that = (ClientIPConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
