package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerPortBuilder extends io.fabric8.kubernetes.api.model.ContainerPortFluentImpl<io.fabric8.kubernetes.api.model.ContainerPortBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerPort,io.fabric8.kubernetes.api.model.ContainerPortBuilder> {

    io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerPortBuilder() {
        this(true);
    }

    public ContainerPortBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerPort instance) {
        this(fluent, instance, true);
    }

    public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPortFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerPort instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainerPort(instance.getContainerPort()); 
        fluent.withHostIP(instance.getHostIP()); 
        fluent.withHostPort(instance.getHostPort()); 
        fluent.withName(instance.getName()); 
        fluent.withProtocol(instance.getProtocol()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPort instance) {
        this(instance,true);
    }

    public ContainerPortBuilder(io.fabric8.kubernetes.api.model.ContainerPort instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainerPort(instance.getContainerPort()); 
        this.withHostIP(instance.getHostIP()); 
        this.withHostPort(instance.getHostPort()); 
        this.withName(instance.getName()); 
        this.withProtocol(instance.getProtocol()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ContainerPort build() {
        ContainerPort buildable = new ContainerPort(fluent.getContainerPort(),fluent.getHostIP(),fluent.getHostPort(),fluent.getName(),fluent.getProtocol());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerPortBuilder that = (ContainerPortBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
