package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FlexVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.FlexVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.FlexVolumeSource,io.fabric8.kubernetes.api.model.FlexVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public FlexVolumeSourceBuilder() {
        this(true);
    }

    public FlexVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new FlexVolumeSource(), validationEnabled);
    }

    public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new FlexVolumeSource(), validationEnabled);
    }

    public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexVolumeSource instance) {
        this(fluent, instance, true);
    }

    public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.FlexVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDriver(instance.getDriver()); 
        fluent.withFsType(instance.getFsType()); 
        fluent.withOptions(instance.getOptions()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSource instance) {
        this(instance,true);
    }

    public FlexVolumeSourceBuilder(io.fabric8.kubernetes.api.model.FlexVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDriver(instance.getDriver()); 
        this.withFsType(instance.getFsType()); 
        this.withOptions(instance.getOptions()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.FlexVolumeSource build() {
        FlexVolumeSource buildable = new FlexVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getOptions(),fluent.getReadOnly(),fluent.getSecretRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FlexVolumeSourceBuilder that = (FlexVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
