package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class LoadBalancerIngressFluentImpl<A extends io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent<A> {

    private java.lang.String hostname;
    private java.lang.String ip;
    private java.util.List<io.fabric8.kubernetes.api.model.PortStatusBuilder> ports =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.PortStatusBuilder>();

    public LoadBalancerIngressFluentImpl() {
    }

    public LoadBalancerIngressFluentImpl(io.fabric8.kubernetes.api.model.LoadBalancerIngress instance) {
        this.withHostname(instance.getHostname()); 
        this.withIp(instance.getIp()); 
        this.withPorts(instance.getPorts()); 
    }

    public java.lang.String getHostname() {
        return this.hostname;
    }

    public A withHostname(java.lang.String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public java.lang.Boolean hasHostname() {
        return this.hostname != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHostname instead.
     */
        public A withNewHostname(java.lang.String arg0) {
        return (A)withHostname(new String(arg0));
    }

    public java.lang.String getIp() {
        return this.ip;
    }

    public A withIp(java.lang.String ip) {
        this.ip=ip; return (A) this;
    }

    public java.lang.Boolean hasIp() {
        return this.ip != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withIp instead.
     */
        public A withNewIp(java.lang.String arg0) {
        return (A)withIp(new String(arg0));
    }

    public A addToPorts(int index,io.fabric8.kubernetes.api.model.PortStatus item) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PortStatusBuilder>();}
        io.fabric8.kubernetes.api.model.PortStatusBuilder builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,io.fabric8.kubernetes.api.model.PortStatus item) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PortStatusBuilder>();}
        io.fabric8.kubernetes.api.model.PortStatusBuilder builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
        if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
         return (A)this;
    }

    public A addToPorts(io.fabric8.kubernetes.api.model.PortStatus... items) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PortStatusBuilder>();}
        for (io.fabric8.kubernetes.api.model.PortStatus item : items) {io.fabric8.kubernetes.api.model.PortStatusBuilder builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.PortStatus> items) {
        if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PortStatusBuilder>();}
        for (io.fabric8.kubernetes.api.model.PortStatus item : items) {io.fabric8.kubernetes.api.model.PortStatusBuilder builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(io.fabric8.kubernetes.api.model.PortStatus... items) {
        for (io.fabric8.kubernetes.api.model.PortStatus item : items) {io.fabric8.kubernetes.api.model.PortStatusBuilder builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.PortStatus> items) {
        for (io.fabric8.kubernetes.api.model.PortStatus item : items) {io.fabric8.kubernetes.api.model.PortStatusBuilder builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PortStatusBuilder> predicate) {
        if (ports == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.PortStatusBuilder> each = ports.iterator();
        final List visitables = _visitables.get("ports");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.PortStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPorts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.PortStatus> getPorts() {
        return build(ports);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.PortStatus> buildPorts() {
        return build(ports);
    }

    public io.fabric8.kubernetes.api.model.PortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.PortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.PortStatus buildLastPort() {
        return this.ports.get(ports.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.PortStatus buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PortStatusBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.PortStatusBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PortStatusBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.PortStatusBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.PortStatus> ports) {
        if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
        if (ports != null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PortStatusBuilder>(); for (io.fabric8.kubernetes.api.model.PortStatus item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(io.fabric8.kubernetes.api.model.PortStatus... ports) {
        if (this.ports != null) {this.ports.clear();}
        if (ports != null) {for (io.fabric8.kubernetes.api.model.PortStatus item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public java.lang.Boolean hasPorts() {
        return ports != null && !ports.isEmpty();
    }

    public A addNewPort(java.lang.String error,java.lang.Integer port,java.lang.String protocol) {
        return (A)addToPorts(new PortStatus(error, port, protocol));
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> addNewPort() {
        return new io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl.PortsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.PortStatus item) {
        return new io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl.PortsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index,io.fabric8.kubernetes.api.model.PortStatus item) {
        return new io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentImpl.PortsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editPort(int index) {
        if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
        return setNewPortLike(index, buildPort(index));
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editFirstPort() {
        if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
        return setNewPortLike(0, buildPort(0));
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editLastPort() {
        int index = ports.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
        return setNewPortLike(index, buildPort(index));
    }

    public io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PortStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ports.size();i++) { 
        if (predicate.test(ports.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
        return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoadBalancerIngressFluentImpl that = (LoadBalancerIngressFluentImpl) o;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
        if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hostname,  ip,  ports,  super.hashCode());
    }

    public class PortsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PortStatusFluentImpl<io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PortStatusBuilder builder;
        private final int index;

            PortsNestedImpl(int index,io.fabric8.kubernetes.api.model.PortStatus item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(this, item);
                        
            }

            PortsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.PortStatusBuilder(this);
                        
            }

            public N and() {
                return (N) LoadBalancerIngressFluentImpl.this.setToPorts(index,builder.build());
            }

            public N endPort() {
                return and();
            }
    }


}
