package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OwnerReferenceBuilder extends io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl<io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.OwnerReference,io.fabric8.kubernetes.api.model.OwnerReferenceBuilder> {

    io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OwnerReferenceBuilder() {
        this(true);
    }

    public OwnerReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new OwnerReference(), validationEnabled);
    }

    public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OwnerReference(), validationEnabled);
    }

    public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.OwnerReference instance) {
        this(fluent, instance, true);
    }

    public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.OwnerReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withBlockOwnerDeletion(instance.getBlockOwnerDeletion()); 
        fluent.withController(instance.getController()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withUid(instance.getUid()); 
        this.validationEnabled = validationEnabled; 
    }

    public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReference instance) {
        this(instance,true);
    }

    public OwnerReferenceBuilder(io.fabric8.kubernetes.api.model.OwnerReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withBlockOwnerDeletion(instance.getBlockOwnerDeletion()); 
        this.withController(instance.getController()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withUid(instance.getUid()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.OwnerReference build() {
        OwnerReference buildable = new OwnerReference(fluent.getApiVersion(),fluent.getBlockOwnerDeletion(),fluent.getController(),fluent.getKind(),fluent.getName(),fluent.getUid());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OwnerReferenceBuilder that = (OwnerReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
