package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RBDPersistentVolumeSourceFluentImpl<A extends io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<A> {

    private java.lang.String fsType;
    private java.lang.String image;
    private java.lang.String keyring;
    private java.util.List<java.lang.String> monitors = new java.util.ArrayList<java.lang.String>();
    private java.lang.String pool;
    private java.lang.Boolean readOnly;
    private io.fabric8.kubernetes.api.model.SecretReferenceBuilder secretRef;
    private java.lang.String user;

    public RBDPersistentVolumeSourceFluentImpl() {
    }

    public RBDPersistentVolumeSourceFluentImpl(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType()); 
        this.withImage(instance.getImage()); 
        this.withKeyring(instance.getKeyring()); 
        this.withMonitors(instance.getMonitors()); 
        this.withPool(instance.getPool()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withUser(instance.getUser()); 
    }

    public java.lang.String getFsType() {
        return this.fsType;
    }

    public A withFsType(java.lang.String fsType) {
        this.fsType=fsType; return (A) this;
    }

    public java.lang.Boolean hasFsType() {
        return this.fsType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFsType instead.
     */
        public A withNewFsType(java.lang.String arg0) {
        return (A)withFsType(new String(arg0));
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String arg0) {
        return (A)withImage(new String(arg0));
    }

    public java.lang.String getKeyring() {
        return this.keyring;
    }

    public A withKeyring(java.lang.String keyring) {
        this.keyring=keyring; return (A) this;
    }

    public java.lang.Boolean hasKeyring() {
        return this.keyring != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyring instead.
     */
        public A withNewKeyring(java.lang.String arg0) {
        return (A)withKeyring(new String(arg0));
    }

    public A addToMonitors(int index,java.lang.String item) {
        if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
        this.monitors.add(index, item);
        return (A)this;
    }

    public A setToMonitors(int index,java.lang.String item) {
        if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
        this.monitors.set(index, item); return (A)this;
    }

    public A addToMonitors(java.lang.String... items) {
        if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A addAllToMonitors(java.util.Collection<java.lang.String> items) {
        if (this.monitors == null) {this.monitors = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A removeFromMonitors(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public A removeAllFromMonitors(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getMonitors() {
        return this.monitors;
    }

    public java.lang.String getMonitor(int index) {
        return this.monitors.get(index);
    }

    public java.lang.String getFirstMonitor() {
        return this.monitors.get(0);
    }

    public java.lang.String getLastMonitor() {
        return this.monitors.get(monitors.size() - 1);
    }

    public java.lang.String getMatchingMonitor(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: monitors) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingMonitor(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: monitors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMonitors(java.util.List<java.lang.String> monitors) {
        if (this.monitors != null) { _visitables.get("monitors").removeAll(this.monitors);}
        if (monitors != null) {this.monitors = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : monitors){this.addToMonitors(item);}} else { this.monitors = null;} return (A) this;
    }

    public A withMonitors(java.lang.String... monitors) {
        if (this.monitors != null) {this.monitors.clear();}
        if (monitors != null) {for (java.lang.String item :monitors){ this.addToMonitors(item);}} return (A) this;
    }

    public java.lang.Boolean hasMonitors() {
        return monitors != null && !monitors.isEmpty();
    }

    public A addNewMonitor(java.lang.String arg0) {
        return (A)addToMonitors(new String(arg0));
    }

    public java.lang.String getPool() {
        return this.pool;
    }

    public A withPool(java.lang.String pool) {
        this.pool=pool; return (A) this;
    }

    public java.lang.Boolean hasPool() {
        return this.pool != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPool instead.
     */
        public A withNewPool(java.lang.String arg0) {
        return (A)withPool(new String(arg0));
    }

    public java.lang.Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(java.lang.Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public java.lang.Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecretRef instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.SecretReference getSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public io.fabric8.kubernetes.api.model.SecretReference buildSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(io.fabric8.kubernetes.api.model.SecretReference secretRef) {
        _visitables.get("secretRef").remove(this.secretRef);
        if (secretRef!=null){ this.secretRef= new io.fabric8.kubernetes.api.model.SecretReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public java.lang.Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(java.lang.String name,java.lang.String namespace) {
        return (A)withSecretRef(new SecretReference(name, namespace));
    }

    public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluentImpl.SecretRefNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.kubernetes.api.model.SecretReference item) {
        return new io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluentImpl.SecretRefNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return withNewSecretRefLike(getSecretRef());
    }

    public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.kubernetes.api.model.SecretReferenceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.kubernetes.api.model.SecretReference item) {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public java.lang.String getUser() {
        return this.user;
    }

    public A withUser(java.lang.String user) {
        this.user=user; return (A) this;
    }

    public java.lang.Boolean hasUser() {
        return this.user != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUser instead.
     */
        public A withNewUser(java.lang.String arg0) {
        return (A)withUser(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RBDPersistentVolumeSourceFluentImpl that = (RBDPersistentVolumeSourceFluentImpl) o;
        if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (keyring != null ? !keyring.equals(that.keyring) :that.keyring != null) return false;
        if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
        if (pool != null ? !pool.equals(that.pool) :that.pool != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsType,  image,  keyring,  monitors,  pool,  readOnly,  secretRef,  user,  super.hashCode());
    }

    public class SecretRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl<io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<N>> implements io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent.SecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.SecretReferenceBuilder builder;

            SecretRefNestedImpl(io.fabric8.kubernetes.api.model.SecretReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.SecretReferenceBuilder(this, item);
                        
            }

            SecretRefNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.SecretReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) RBDPersistentVolumeSourceFluentImpl.this.withSecretRef(builder.build());
            }

            public N endSecretRef() {
                return and();
            }
    }


}
