package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServicePortBuilder extends io.fabric8.kubernetes.api.model.ServicePortFluentImpl<io.fabric8.kubernetes.api.model.ServicePortBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServicePort,io.fabric8.kubernetes.api.model.ServicePortBuilder> {

    io.fabric8.kubernetes.api.model.ServicePortFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServicePortBuilder() {
        this(true);
    }

    public ServicePortBuilder(java.lang.Boolean validationEnabled) {
        this(new ServicePort(), validationEnabled);
    }

    public ServicePortBuilder(io.fabric8.kubernetes.api.model.ServicePortFluent<?> fluent) {
        this(fluent, true);
    }

    public ServicePortBuilder(io.fabric8.kubernetes.api.model.ServicePortFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServicePort(), validationEnabled);
    }

    public ServicePortBuilder(io.fabric8.kubernetes.api.model.ServicePortFluent<?> fluent,io.fabric8.kubernetes.api.model.ServicePort instance) {
        this(fluent, instance, true);
    }

    public ServicePortBuilder(io.fabric8.kubernetes.api.model.ServicePortFluent<?> fluent,io.fabric8.kubernetes.api.model.ServicePort instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAppProtocol(instance.getAppProtocol()); 
        fluent.withName(instance.getName()); 
        fluent.withNodePort(instance.getNodePort()); 
        fluent.withPort(instance.getPort()); 
        fluent.withProtocol(instance.getProtocol()); 
        fluent.withTargetPort(instance.getTargetPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServicePortBuilder(io.fabric8.kubernetes.api.model.ServicePort instance) {
        this(instance,true);
    }

    public ServicePortBuilder(io.fabric8.kubernetes.api.model.ServicePort instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAppProtocol(instance.getAppProtocol()); 
        this.withName(instance.getName()); 
        this.withNodePort(instance.getNodePort()); 
        this.withPort(instance.getPort()); 
        this.withProtocol(instance.getProtocol()); 
        this.withTargetPort(instance.getTargetPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ServicePort build() {
        ServicePort buildable = new ServicePort(fluent.getAppProtocol(),fluent.getName(),fluent.getNodePort(),fluent.getPort(),fluent.getProtocol(),fluent.getTargetPort());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServicePortBuilder that = (ServicePortBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
