package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamedClusterBuilder extends NamedClusterFluent<NamedClusterBuilder> implements VisitableBuilder<NamedCluster,NamedClusterBuilder>{
  public NamedClusterBuilder() {
    this(new NamedCluster());
  }
  
  public NamedClusterBuilder(NamedClusterFluent<?> fluent) {
    this(fluent, new NamedCluster());
  }
  
  public NamedClusterBuilder(NamedClusterFluent<?> fluent,NamedCluster instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamedClusterBuilder(NamedCluster instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamedClusterFluent<?> fluent;
  
  public NamedCluster build() {
    NamedCluster buildable = new NamedCluster(fluent.buildCluster(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}