package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceRequirementsBuilder extends ResourceRequirementsFluent<ResourceRequirementsBuilder> implements VisitableBuilder<ResourceRequirements,ResourceRequirementsBuilder>{
  public ResourceRequirementsBuilder() {
    this(new ResourceRequirements());
  }
  
  public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent) {
    this(fluent, new ResourceRequirements());
  }
  
  public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent,ResourceRequirements instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceRequirementsBuilder(ResourceRequirements instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceRequirementsFluent<?> fluent;
  
  public ResourceRequirements build() {
    ResourceRequirements buildable = new ResourceRequirements(fluent.buildClaims(),fluent.getLimits(),fluent.getRequests());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}