package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ModifyVolumeStatusBuilder extends ModifyVolumeStatusFluent<ModifyVolumeStatusBuilder> implements VisitableBuilder<ModifyVolumeStatus,ModifyVolumeStatusBuilder>{
  public ModifyVolumeStatusBuilder() {
    this(new ModifyVolumeStatus());
  }
  
  public ModifyVolumeStatusBuilder(ModifyVolumeStatusFluent<?> fluent) {
    this(fluent, new ModifyVolumeStatus());
  }
  
  public ModifyVolumeStatusBuilder(ModifyVolumeStatusFluent<?> fluent,ModifyVolumeStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ModifyVolumeStatusBuilder(ModifyVolumeStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ModifyVolumeStatusFluent<?> fluent;
  
  public ModifyVolumeStatus build() {
    ModifyVolumeStatus buildable = new ModifyVolumeStatus(fluent.getStatus(),fluent.getTargetVolumeAttributesClassName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}