package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ResourceClaimBuilder extends ResourceClaimFluent<ResourceClaimBuilder> implements VisitableBuilder<ResourceClaim,ResourceClaimBuilder>{
  public ResourceClaimBuilder() {
    this(new ResourceClaim());
  }
  
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent) {
    this(fluent, new ResourceClaim());
  }
  
  public ResourceClaimBuilder(ResourceClaimFluent<?> fluent,ResourceClaim instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ResourceClaimBuilder(ResourceClaim instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ResourceClaimFluent<?> fluent;
  
  public ResourceClaim build() {
    ResourceClaim buildable = new ResourceClaim(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}