package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretListBuilder extends SecretListFluent<SecretListBuilder> implements VisitableBuilder<SecretList,SecretListBuilder>{
  public SecretListBuilder() {
    this(new SecretList());
  }
  
  public SecretListBuilder(SecretListFluent<?> fluent) {
    this(fluent, new SecretList());
  }
  
  public SecretListBuilder(SecretListFluent<?> fluent,SecretList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretListBuilder(SecretList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretListFluent<?> fluent;
  
  public SecretList build() {
    SecretList buildable = new SecretList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}