package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkPolicyListBuilder extends NetworkPolicyListFluent<NetworkPolicyListBuilder> implements VisitableBuilder<NetworkPolicyList,NetworkPolicyListBuilder>{
  public NetworkPolicyListBuilder() {
    this(new NetworkPolicyList());
  }
  
  public NetworkPolicyListBuilder(NetworkPolicyListFluent<?> fluent) {
    this(fluent, new NetworkPolicyList());
  }
  
  public NetworkPolicyListBuilder(NetworkPolicyListFluent<?> fluent,NetworkPolicyList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkPolicyListBuilder(NetworkPolicyList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkPolicyListFluent<?> fluent;
  
  public NetworkPolicyList build() {
    NetworkPolicyList buildable = new NetworkPolicyList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}