package io.fabric8.kubernetes.api.model.flowcontrol.v1beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LimitResponseFluent<A extends LimitResponseFluent<A>> extends BaseFluent<A>{
  public LimitResponseFluent() {
  }
  
  public LimitResponseFluent(LimitResponse instance) {
    this.copyInstance(instance);
  }
  private QueuingConfigurationBuilder queuing;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LimitResponse instance) {
    instance = (instance != null ? instance : new LimitResponse());
    if (instance != null) {
          this.withQueuing(instance.getQueuing());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public QueuingConfiguration buildQueuing() {
    return this.queuing != null ? this.queuing.build() : null;
  }
  
  public A withQueuing(QueuingConfiguration queuing) {
    this._visitables.remove("queuing");
    if (queuing != null) {
        this.queuing = new QueuingConfigurationBuilder(queuing);
        this._visitables.get("queuing").add(this.queuing);
    } else {
        this.queuing = null;
        this._visitables.get("queuing").remove(this.queuing);
    }
    return (A) this;
  }
  
  public boolean hasQueuing() {
    return this.queuing != null;
  }
  
  public A withNewQueuing(Integer handSize,Integer queueLengthLimit,Integer queues) {
    return (A)withQueuing(new QueuingConfiguration(handSize, queueLengthLimit, queues));
  }
  
  public QueuingNested<A> withNewQueuing() {
    return new QueuingNested(null);
  }
  
  public QueuingNested<A> withNewQueuingLike(QueuingConfiguration item) {
    return new QueuingNested(item);
  }
  
  public QueuingNested<A> editQueuing() {
    return withNewQueuingLike(java.util.Optional.ofNullable(buildQueuing()).orElse(null));
  }
  
  public QueuingNested<A> editOrNewQueuing() {
    return withNewQueuingLike(java.util.Optional.ofNullable(buildQueuing()).orElse(new QueuingConfigurationBuilder().build()));
  }
  
  public QueuingNested<A> editOrNewQueuingLike(QueuingConfiguration item) {
    return withNewQueuingLike(java.util.Optional.ofNullable(buildQueuing()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LimitResponseFluent that = (LimitResponseFluent) o;
    if (!java.util.Objects.equals(queuing, that.queuing)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(queuing,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (queuing != null) { sb.append("queuing:"); sb.append(queuing + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class QueuingNested<N> extends QueuingConfigurationFluent<QueuingNested<N>> implements Nested<N>{
    QueuingNested(QueuingConfiguration item) {
      this.builder = new QueuingConfigurationBuilder(this, item);
    }
    QueuingConfigurationBuilder builder;
    
    public N and() {
      return (N) LimitResponseFluent.this.withQueuing(builder.build());
    }
    
    public N endQueuing() {
      return and();
    }
    
  
  }

}