package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HTTPRouteSpecBuilder extends HTTPRouteSpecFluent<HTTPRouteSpecBuilder> implements VisitableBuilder<HTTPRouteSpec,HTTPRouteSpecBuilder>{
  public HTTPRouteSpecBuilder() {
    this(new HTTPRouteSpec());
  }
  
  public HTTPRouteSpecBuilder(HTTPRouteSpecFluent<?> fluent) {
    this(fluent, new HTTPRouteSpec());
  }
  
  public HTTPRouteSpecBuilder(HTTPRouteSpecFluent<?> fluent,HTTPRouteSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HTTPRouteSpecBuilder(HTTPRouteSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HTTPRouteSpecFluent<?> fluent;
  
  public HTTPRouteSpec build() {
    HTTPRouteSpec buildable = new HTTPRouteSpec(fluent.getHostnames(),fluent.buildParentRefs(),fluent.buildRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}