/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.util.NameHelper;

public class Fabric8NameHelper
extends NameHelper {
    private static final Pattern SINGLE_LETTER_PREFIX_WORD_PROPERTY = Pattern.compile("^[a-z]((-[a-zA-Z])|[A-Z])(.*)$");

    public Fabric8NameHelper(GenerationConfig generationConfig) {
        super(generationConfig);
    }

    public String getGetterName(String propertyName, JType type, JsonNode node) {
        return Fabric8NameHelper.correctCamelCaseWithPrefix(propertyName, super.getGetterName(propertyName, type, node));
    }

    public String getSetterName(String propertyName, JsonNode node) {
        return Fabric8NameHelper.correctCamelCaseWithPrefix(propertyName, super.getSetterName(propertyName, node));
    }

    static String correctCamelCaseWithPrefix(String propertyName, String functionName) {
        Matcher m = SINGLE_LETTER_PREFIX_WORD_PROPERTY.matcher(propertyName);
        if (m.matches()) {
            return functionName.substring(0, 3) + functionName.substring(3, 4).toUpperCase() + functionName.substring(4);
        }
        return functionName;
    }
}

