/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jsonschema2pojo;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.model.jackson.UnwrappedTypeResolverBuilder;
import java.util.ArrayList;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.ObjectRule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.ParcelableHelper;
import org.jsonschema2pojo.util.ReflectionHelper;

public class Fabric8ObjectRule
extends ObjectRule {
    private static final String INTERFACE_TYPE_PROPERTY = "interfaceType";
    private static final String INTERFACE_IMPLEMENTATIONS_TYPE_PROPERTY = "interfaceImpls";
    private static final String VALUE_PROPERTY = "value";
    private final RuleFactory ruleFactory;

    protected Fabric8ObjectRule(RuleFactory ruleFactory, ParcelableHelper parcelableHelper, ReflectionHelper reflectionHelper) {
        super(ruleFactory, parcelableHelper, reflectionHelper);
        this.ruleFactory = ruleFactory;
    }

    public JType apply(String nodeName, JsonNode node, JsonNode parent, JPackage _package, Schema schema) {
        if (node.has(INTERFACE_TYPE_PROPERTY)) {
            return this.createInterface(node, _package);
        }
        return super.apply(nodeName, node, parent, _package, schema);
    }

    private JType createInterface(JsonNode node, JPackage _package) {
        JDefinedClass newType;
        String fqn = node.path(INTERFACE_TYPE_PROPERTY).asText();
        int index = fqn.lastIndexOf(".") + 1;
        try {
            newType = _package._interface(fqn.substring(index));
        }
        catch (JClassAlreadyExistsException ex) {
            return ex.getExistingClass();
        }
        this.ruleFactory.getAnnotator().typeInfo(newType, node);
        this.ruleFactory.getAnnotator().propertyInclusion(newType, node);
        if (node.has(INTERFACE_IMPLEMENTATIONS_TYPE_PROPERTY)) {
            newType.annotate(JsonTypeResolver.class).param(VALUE_PROPERTY, UnwrappedTypeResolverBuilder.class);
            JAnnotationArrayMember subTypes = newType.annotate(JsonSubTypes.class).paramArray(VALUE_PROPERTY);
            JsonNode implementationsNode = node.get(INTERFACE_IMPLEMENTATIONS_TYPE_PROPERTY);
            ArrayList<String> implementations = new ArrayList<String>();
            for (JsonNode implementationNode : implementationsNode) {
                String implementation = implementationNode.textValue();
                implementations.add(implementation);
                subTypes.annotate(JsonSubTypes.Type.class).param(VALUE_PROPERTY, (JType)new JCodeModel().ref(implementation));
            }
            JAnnotationUse jsonTypeAnnotation = newType.annotate(JsonTypeInfo.class).param("use", (Enum)JsonTypeInfo.Id.DEDUCTION);
            if (implementations.size() == 1) {
                jsonTypeAnnotation.param("defaultImpl", (JType)new JCodeModel().ref((String)implementations.get(0)));
            }
        }
        return newType;
    }
}

