package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IPAddressBuilder extends IPAddressFluent<IPAddressBuilder> implements VisitableBuilder<IPAddress,IPAddressBuilder>{
  public IPAddressBuilder() {
    this(new IPAddress());
  }
  
  public IPAddressBuilder(IPAddressFluent<?> fluent) {
    this(fluent, new IPAddress());
  }
  
  public IPAddressBuilder(IPAddressFluent<?> fluent,IPAddress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IPAddressBuilder(IPAddress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IPAddressFluent<?> fluent;
  
  public IPAddress build() {
    IPAddress buildable = new IPAddress(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}